/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.CharsetHelper;

public enum CodePage {
    ANSI("ANSI", CharsetHelper.CP1252),
    MAC("MAC", CharsetHelper.MAC_ROMAN),
    LATIN("850", CharsetHelper.CP850),
    US("437", CharsetHelper.CP437),
    ZH("ZH", CharsetHelper.GB2312),
    RU("RU", CharsetHelper.CP1251);

    private String m_value;
    private Charset m_charset;
    private static final Map<String, CodePage> NAME_MAP;

    private CodePage(String value, Charset charset) {
        this.m_value = value;
        this.m_charset = charset;
    }

    public static CodePage getInstance(String value) {
        CodePage result = NAME_MAP.get(value);
        if (result == null) {
            result = ANSI;
        }
        return result;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    public String toString() {
        return this.m_value;
    }

    static {
        NAME_MAP = new HashMap<String, CodePage>();
        for (CodePage e2 : EnumSet.allOf(CodePage.class)) {
            NAME_MAP.put(e2.m_value, e2);
        }
    }
}

