/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.tools;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventSerializer
extends DefaultHandler
implements LexicalHandler {
    private Writer _writer;
    private boolean _charactersAreCDATA;
    private StringBuffer _characters;
    private Stack _namespaceStack = new Stack();
    protected List _namespaceAttributes;

    public SAXEventSerializer(OutputStream s2) throws IOException {
        this._writer = new OutputStreamWriter(s2);
        this._charactersAreCDATA = false;
    }

    public void startDocument() throws SAXException {
        try {
            this._writer.write("<sax xmlns=\"http://www.sun.com/xml/sax-events\">\n");
            this._writer.write("<startDocument/>\n");
            this._writer.flush();
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this._writer.write("<endDocument/>\n");
            this._writer.write("</sax>");
            this._writer.flush();
            this._writer.close();
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._namespaceAttributes == null) {
            this._namespaceAttributes = new ArrayList();
        }
        String qName = prefix.length() == 0 ? "xmlns" : "xmlns" + prefix;
        AttributeValueHolder attribute = new AttributeValueHolder(qName, prefix, uri, null, null);
        this._namespaceAttributes.add(attribute);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            int i2;
            int i3;
            AttributeValueHolder[] attrsHolder;
            this.outputCharacters();
            if (this._namespaceAttributes != null) {
                attrsHolder = new AttributeValueHolder[]{};
                attrsHolder = this._namespaceAttributes.toArray(attrsHolder);
                this.quicksort(attrsHolder, 0, attrsHolder.length - 1);
                for (i3 = 0; i3 < attrsHolder.length; ++i3) {
                    this._writer.write("<startPrefixMapping prefix=\"" + attrsHolder[i3].localName + "\" uri=\"" + attrsHolder[i3].uri + "\"/>\n");
                    this._writer.flush();
                }
                this._namespaceStack.push(attrsHolder);
                this._namespaceAttributes = null;
            } else {
                this._namespaceStack.push(null);
            }
            attrsHolder = new AttributeValueHolder[attributes.getLength()];
            for (i3 = 0; i3 < attributes.getLength(); ++i3) {
                attrsHolder[i3] = new AttributeValueHolder(attributes.getQName(i3), attributes.getLocalName(i3), attributes.getURI(i3), attributes.getType(i3), attributes.getValue(i3));
            }
            this.quicksort(attrsHolder, 0, attrsHolder.length - 1);
            int attributeCount = 0;
            for (i2 = 0; i2 < attrsHolder.length; ++i2) {
                if (attrsHolder[i2].uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                ++attributeCount;
            }
            if (attributeCount == 0) {
                this._writer.write("<startElement uri=\"" + uri + "\" localName=\"" + localName + "\" qName=\"" + qName + "\"/>\n");
                return;
            }
            this._writer.write("<startElement uri=\"" + uri + "\" localName=\"" + localName + "\" qName=\"" + qName + "\">\n");
            for (i2 = 0; i2 < attrsHolder.length; ++i2) {
                if (attrsHolder[i2].uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                this._writer.write("  <attribute qName=\"" + attrsHolder[i2].qName + "\" localName=\"" + attrsHolder[i2].localName + "\" uri=\"" + attrsHolder[i2].uri + "\" value=\"" + attrsHolder[i2].value + "\"/>\n");
            }
            this._writer.write("</startElement>\n");
            this._writer.flush();
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<endElement uri=\"" + uri + "\" localName=\"" + localName + "\" qName=\"" + qName + "\"/>\n");
            this._writer.flush();
            AttributeValueHolder[] attrsHolder = (AttributeValueHolder[])this._namespaceStack.pop();
            if (attrsHolder != null) {
                for (int i2 = 0; i2 < attrsHolder.length; ++i2) {
                    this._writer.write("<endPrefixMapping prefix=\"" + attrsHolder[i2].localName + "\"/>\n");
                    this._writer.flush();
                }
            }
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this._characters == null) {
            this._characters = new StringBuffer();
        }
        this._characters.append(ch, start, length);
    }

    private void outputCharacters() throws SAXException {
        if (this._characters == null) {
            return;
        }
        try {
            this._writer.write("<characters>" + (this._charactersAreCDATA ? "<![CDATA[" : "") + this._characters + (this._charactersAreCDATA ? "]]>" : "") + "</characters>\n");
            this._writer.flush();
            this._characters = null;
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<processingInstruction target=\"" + target + "\" data=\"" + data + "\"/>\n");
            this._writer.flush();
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this._charactersAreCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this._charactersAreCDATA = false;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<comment>" + new String(ch, start, length) + "</comment>\n");
            this._writer.flush();
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    private void quicksort(AttributeValueHolder[] attrs, int p2, int r2) {
        while (p2 < r2) {
            int q2 = this.partition(attrs, p2, r2);
            this.quicksort(attrs, p2, q2);
            p2 = q2 + 1;
        }
    }

    private int partition(AttributeValueHolder[] attrs, int p2, int r2) {
        AttributeValueHolder x2 = attrs[p2 + r2 >>> 1];
        int i2 = p2 - 1;
        int j2 = r2 + 1;
        while (true) {
            if (x2.compareTo(attrs[--j2]) < 0) {
                continue;
            }
            while (x2.compareTo(attrs[++i2]) > 0) {
            }
            if (i2 >= j2) break;
            AttributeValueHolder t2 = attrs[i2];
            attrs[i2] = attrs[j2];
            attrs[j2] = t2;
        }
        return j2;
    }

    public static class AttributeValueHolder
    implements Comparable {
        public final String qName;
        public final String localName;
        public final String uri;
        public final String type;
        public final String value;

        public AttributeValueHolder(String qName, String localName, String uri, String type, String value) {
            this.qName = qName;
            this.localName = localName;
            this.uri = uri;
            this.type = type;
            this.value = value;
        }

        public int compareTo(Object o2) {
            try {
                return this.qName.compareTo(((AttributeValueHolder)o2).qName);
            }
            catch (Exception e2) {
                throw new RuntimeException(CommonResourceBundle.getInstance().getString("message.AttributeValueHolderExpected"));
            }
        }
    }
}

