/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.EncodingConstants;
import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.fastinfoset.org.apache.xerces.util.XMLChar;
import com.sun.xml.fastinfoset.util.CharArrayIntMap;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.fastinfoset.util.StringIntMap;
import com.sun.xml.fastinfoset.vocab.SerializerVocabulary;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.fastinfoset.EncodingAlgorithm;
import org.jvnet.fastinfoset.EncodingAlgorithmException;
import org.jvnet.fastinfoset.ExternalVocabulary;
import org.jvnet.fastinfoset.FastInfosetException;
import org.jvnet.fastinfoset.FastInfosetSerializer;
import org.jvnet.fastinfoset.VocabularyApplicationData;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Encoder
extends DefaultHandler
implements FastInfosetSerializer {
    public static final String CHARACTER_ENCODING_SCHEME_SYSTEM_PROPERTY = "com.sun.xml.fastinfoset.serializer.character-encoding-scheme";
    protected static final String _characterEncodingSchemeSystemDefault;
    private static int[] NUMERIC_CHARACTERS_TABLE;
    private static int[] DATE_TIME_CHARACTERS_TABLE;
    private boolean _ignoreDTD;
    private boolean _ignoreComments;
    private boolean _ignoreProcessingInstructions;
    private boolean _ignoreWhiteSpaceTextContent;
    private boolean _useLocalNameAsKeyForQualifiedNameLookup;
    private boolean _encodingStringsAsUtf8 = true;
    private int _nonIdentifyingStringOnThirdBitCES;
    private int _nonIdentifyingStringOnFirstBitCES;
    private Map _registeredEncodingAlgorithms = new HashMap();
    protected SerializerVocabulary _v;
    protected VocabularyApplicationData _vData;
    private boolean _vIsInternal;
    protected boolean _terminate = false;
    protected int _b;
    protected OutputStream _s;
    protected char[] _charBuffer = new char[512];
    protected byte[] _octetBuffer = new byte[1024];
    protected int _octetBufferIndex;
    protected int _markIndex = -1;
    protected int minAttributeValueSize = 0;
    protected int maxAttributeValueSize = 32;
    protected int attributeValueMapTotalCharactersConstraint = 0x3FFFFFFF;
    protected int minCharacterContentChunkSize = 0;
    protected int maxCharacterContentChunkSize = 32;
    protected int characterContentChunkMapTotalCharactersConstraint = 0x3FFFFFFF;
    private int _bitsLeftInOctet;
    private EncodingBufferOutputStream _encodingBufferOutputStream = new EncodingBufferOutputStream();
    private byte[] _encodingBuffer = new byte[512];
    private int _encodingBufferIndex;

    private static String getDefaultEncodingScheme() {
        String p2 = System.getProperty(CHARACTER_ENCODING_SCHEME_SYSTEM_PROPERTY, "UTF-8");
        if (p2.equals("UTF-16BE")) {
            return "UTF-16BE";
        }
        return "UTF-8";
    }

    private static int maxCharacter(String alphabet) {
        char c2 = '\u0000';
        for (int i2 = 0; i2 < alphabet.length(); ++i2) {
            if (c2 >= alphabet.charAt(i2)) continue;
            c2 = alphabet.charAt(i2);
        }
        return c2;
    }

    protected Encoder() {
        this.setCharacterEncodingScheme(_characterEncodingSchemeSystemDefault);
    }

    protected Encoder(boolean useLocalNameAsKeyForQualifiedNameLookup) {
        this.setCharacterEncodingScheme(_characterEncodingSchemeSystemDefault);
        this._useLocalNameAsKeyForQualifiedNameLookup = useLocalNameAsKeyForQualifiedNameLookup;
    }

    public final void setIgnoreDTD(boolean ignoreDTD) {
        this._ignoreDTD = ignoreDTD;
    }

    public final boolean getIgnoreDTD() {
        return this._ignoreDTD;
    }

    public final void setIgnoreComments(boolean ignoreComments) {
        this._ignoreComments = ignoreComments;
    }

    public final boolean getIgnoreComments() {
        return this._ignoreComments;
    }

    public final void setIgnoreProcesingInstructions(boolean ignoreProcesingInstructions) {
        this._ignoreProcessingInstructions = ignoreProcesingInstructions;
    }

    public final boolean getIgnoreProcesingInstructions() {
        return this._ignoreProcessingInstructions;
    }

    public final void setIgnoreWhiteSpaceTextContent(boolean ignoreWhiteSpaceTextContent) {
        this._ignoreWhiteSpaceTextContent = ignoreWhiteSpaceTextContent;
    }

    public final boolean getIgnoreWhiteSpaceTextContent() {
        return this._ignoreWhiteSpaceTextContent;
    }

    public void setCharacterEncodingScheme(String characterEncodingScheme) {
        if (characterEncodingScheme.equals("UTF-16BE")) {
            this._encodingStringsAsUtf8 = false;
            this._nonIdentifyingStringOnThirdBitCES = 132;
            this._nonIdentifyingStringOnFirstBitCES = 16;
        } else {
            this._encodingStringsAsUtf8 = true;
            this._nonIdentifyingStringOnThirdBitCES = 128;
            this._nonIdentifyingStringOnFirstBitCES = 0;
        }
    }

    public String getCharacterEncodingScheme() {
        return this._encodingStringsAsUtf8 ? "UTF-8" : "UTF-16BE";
    }

    public void setRegisteredEncodingAlgorithms(Map algorithms) {
        this._registeredEncodingAlgorithms = algorithms;
        if (this._registeredEncodingAlgorithms == null) {
            this._registeredEncodingAlgorithms = new HashMap();
        }
    }

    public Map getRegisteredEncodingAlgorithms() {
        return this._registeredEncodingAlgorithms;
    }

    public int getMinCharacterContentChunkSize() {
        return this.minCharacterContentChunkSize;
    }

    public void setMinCharacterContentChunkSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.minCharacterContentChunkSize = size;
    }

    public int getMaxCharacterContentChunkSize() {
        return this.maxCharacterContentChunkSize;
    }

    public void setMaxCharacterContentChunkSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.maxCharacterContentChunkSize = size;
    }

    public int getCharacterContentChunkMapMemoryLimit() {
        return this.characterContentChunkMapTotalCharactersConstraint * 2;
    }

    public void setCharacterContentChunkMapMemoryLimit(int size) {
        if (size < 0) {
            size = 0;
        }
        this.characterContentChunkMapTotalCharactersConstraint = size / 2;
    }

    public boolean isCharacterContentChunkLengthMatchesLimit(int length) {
        return length >= this.minCharacterContentChunkSize && length < this.maxCharacterContentChunkSize;
    }

    public boolean canAddCharacterContentToTable(int length, CharArrayIntMap map) {
        return map.getTotalCharacterCount() + length < this.characterContentChunkMapTotalCharactersConstraint;
    }

    public int getMinAttributeValueSize() {
        return this.minAttributeValueSize;
    }

    public void setMinAttributeValueSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.minAttributeValueSize = size;
    }

    public int getMaxAttributeValueSize() {
        return this.maxAttributeValueSize;
    }

    public void setMaxAttributeValueSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.maxAttributeValueSize = size;
    }

    public void setAttributeValueMapMemoryLimit(int size) {
        if (size < 0) {
            size = 0;
        }
        this.attributeValueMapTotalCharactersConstraint = size / 2;
    }

    public int getAttributeValueMapMemoryLimit() {
        return this.attributeValueMapTotalCharactersConstraint * 2;
    }

    public boolean isAttributeValueLengthMatchesLimit(int length) {
        return length >= this.minAttributeValueSize && length < this.maxAttributeValueSize;
    }

    public boolean canAddAttributeToTable(int length) {
        return this._v.attributeValue.getTotalCharacterCount() + length < this.attributeValueMapTotalCharactersConstraint;
    }

    public void setExternalVocabulary(ExternalVocabulary v2) {
        this._v = new SerializerVocabulary();
        SerializerVocabulary ev = new SerializerVocabulary(v2.vocabulary, this._useLocalNameAsKeyForQualifiedNameLookup);
        this._v.setExternalVocabulary(v2.URI, ev, false);
        this._vIsInternal = true;
    }

    public void setVocabularyApplicationData(VocabularyApplicationData data) {
        this._vData = data;
    }

    public VocabularyApplicationData getVocabularyApplicationData() {
        return this._vData;
    }

    public void reset() {
        this._terminate = false;
    }

    public void setOutputStream(OutputStream s2) {
        this._octetBufferIndex = 0;
        this._markIndex = -1;
        this._s = s2;
    }

    public void setVocabulary(SerializerVocabulary vocabulary) {
        this._v = vocabulary;
        this._vIsInternal = false;
    }

    protected final void encodeHeader(boolean encodeXmlDecl) throws IOException {
        if (encodeXmlDecl) {
            this._s.write(EncodingConstants.XML_DECLARATION_VALUES[0]);
        }
        this._s.write(EncodingConstants.BINARY_HEADER);
    }

    protected final void encodeInitialVocabulary() throws IOException {
        if (this._v == null) {
            this._v = new SerializerVocabulary();
            this._vIsInternal = true;
        } else if (this._vIsInternal) {
            this._v.clear();
            if (this._vData != null) {
                this._vData.clear();
            }
        }
        if (!this._v.hasInitialVocabulary() && !this._v.hasExternalVocabulary()) {
            this.write(0);
        } else if (this._v.hasInitialVocabulary()) {
            this._b = 32;
            this.write(this._b);
            SerializerVocabulary initialVocabulary = this._v.getReadOnlyVocabulary();
            if (initialVocabulary.hasExternalVocabulary()) {
                this._b = 16;
                this.write(this._b);
                this.write(0);
            }
            if (initialVocabulary.hasExternalVocabulary()) {
                this.encodeNonEmptyOctetStringOnSecondBit(this._v.getExternalVocabularyURI());
            }
        } else if (this._v.hasExternalVocabulary()) {
            this._b = 32;
            this.write(this._b);
            this._b = 16;
            this.write(this._b);
            this.write(0);
            this.encodeNonEmptyOctetStringOnSecondBit(this._v.getExternalVocabularyURI());
        }
    }

    protected final void encodeDocumentTermination() throws IOException {
        this.encodeElementTermination();
        this.encodeTermination();
        this._flush();
        this._s.flush();
    }

    protected final void encodeElementTermination() throws IOException {
        this._terminate = true;
        switch (this._b) {
            case 240: {
                this._b = 255;
                break;
            }
            case 255: {
                this.write(255);
            }
            default: {
                this._b = 240;
            }
        }
    }

    protected final void encodeTermination() throws IOException {
        if (this._terminate) {
            this.write(this._b);
            this._b = 0;
            this._terminate = false;
        }
    }

    protected final void encodeNamespaceAttribute(String prefix, String uri) throws IOException {
        this._b = 204;
        if (prefix.length() > 0) {
            this._b |= 2;
        }
        if (uri.length() > 0) {
            this._b |= 1;
        }
        this.write(this._b);
        if (prefix.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(prefix, this._v.prefix);
        }
        if (uri.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(uri, this._v.namespaceName);
        }
    }

    protected final void encodeCharacters(char[] ch, int offset, int length) throws IOException {
        boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
        this.encodeNonIdentifyingStringOnThirdBit(ch, offset, length, this._v.characterContentChunk, addToTable, true);
    }

    protected final void encodeCharactersNoClone(char[] ch, int offset, int length) throws IOException {
        boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
        this.encodeNonIdentifyingStringOnThirdBit(ch, offset, length, this._v.characterContentChunk, addToTable, false);
    }

    protected final void encodeNumericFourBitCharacters(char[] ch, int offset, int length, boolean addToTable) throws FastInfosetException, IOException {
        this.encodeFourBitCharacters(0, NUMERIC_CHARACTERS_TABLE, ch, offset, length, addToTable);
    }

    protected final void encodeDateTimeFourBitCharacters(char[] ch, int offset, int length, boolean addToTable) throws FastInfosetException, IOException {
        this.encodeFourBitCharacters(1, DATE_TIME_CHARACTERS_TABLE, ch, offset, length, addToTable);
    }

    protected final void encodeFourBitCharacters(int id2, int[] table, char[] ch, int offset, int length, boolean addToTable) throws FastInfosetException, IOException {
        if (addToTable) {
            int index;
            boolean canAddCharacterContentToTable = this.canAddCharacterContentToTable(length, this._v.characterContentChunk);
            int n2 = index = canAddCharacterContentToTable ? this._v.characterContentChunk.obtainIndex(ch, offset, length, true) : this._v.characterContentChunk.get(ch, offset, length);
            if (index != -1) {
                this._b = 160;
                this.encodeNonZeroIntegerOnFourthBit(index);
                return;
            }
            this._b = canAddCharacterContentToTable ? 152 : 136;
        } else {
            this._b = 136;
        }
        this.write(this._b);
        this._b = id2 << 2;
        this.encodeNonEmptyFourBitCharacterStringOnSeventhBit(table, ch, offset, length);
    }

    protected final void encodeAlphabetCharacters(String alphabet, char[] ch, int offset, int length, boolean addToTable) throws FastInfosetException, IOException {
        if (addToTable) {
            int index;
            boolean canAddCharacterContentToTable = this.canAddCharacterContentToTable(length, this._v.characterContentChunk);
            int n2 = index = canAddCharacterContentToTable ? this._v.characterContentChunk.obtainIndex(ch, offset, length, true) : this._v.characterContentChunk.get(ch, offset, length);
            if (index != -1) {
                this._b = 160;
                this.encodeNonZeroIntegerOnFourthBit(index);
                return;
            }
            this._b = canAddCharacterContentToTable ? 152 : 136;
        } else {
            this._b = 136;
        }
        int id2 = this._v.restrictedAlphabet.get(alphabet);
        if (id2 == -1) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.restrictedAlphabetNotPresent"));
        }
        this._b |= ((id2 += 32) & 0xC0) >> 6;
        this.write(this._b);
        this._b = (id2 & 0x3F) << 2;
        this.encodeNonEmptyNBitCharacterStringOnSeventhBit(alphabet, ch, offset, length);
    }

    protected final void encodeProcessingInstruction(String target, String data) throws IOException {
        this.write(225);
        this.encodeIdentifyingNonEmptyStringOnFirstBit(target, this._v.otherNCName);
        boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(data.length());
        this.encodeNonIdentifyingStringOnFirstBit(data, this._v.otherString, addToTable);
    }

    protected final void encodeDocumentTypeDeclaration(String systemId, String publicId) throws IOException {
        this._b = 196;
        if (systemId != null && systemId.length() > 0) {
            this._b |= 2;
        }
        if (publicId != null && publicId.length() > 0) {
            this._b |= 1;
        }
        this.write(this._b);
        if (systemId != null && systemId.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(systemId, this._v.otherURI);
        }
        if (publicId != null && publicId.length() > 0) {
            this.encodeIdentifyingNonEmptyStringOnFirstBit(publicId, this._v.otherURI);
        }
    }

    protected final void encodeComment(char[] ch, int offset, int length) throws IOException {
        this.write(226);
        boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
        this.encodeNonIdentifyingStringOnFirstBit(ch, offset, length, this._v.otherString, addToTable, true);
    }

    protected final void encodeCommentNoClone(char[] ch, int offset, int length) throws IOException {
        this.write(226);
        boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
        this.encodeNonIdentifyingStringOnFirstBit(ch, offset, length, this._v.otherString, addToTable, false);
    }

    protected final void encodeElementQualifiedNameOnThirdBit(String namespaceURI, String prefix, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(localName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            for (int i2 = 0; i2 < entry._valueIndex; ++i2) {
                if (prefix != names[i2].prefix && !prefix.equals(names[i2].prefix) || namespaceURI != names[i2].namespaceName && !namespaceURI.equals(names[i2].namespaceName)) continue;
                this.encodeNonZeroIntegerOnThirdBit(names[i2].index);
                return;
            }
        }
        this.encodeLiteralElementQualifiedNameOnThirdBit(namespaceURI, prefix, localName, entry);
    }

    protected final void encodeLiteralElementQualifiedNameOnThirdBit(String namespaceURI, String prefix, String localName, LocalNameQualifiedNamesMap.Entry entry) throws IOException {
        QualifiedName name = new QualifiedName(prefix, namespaceURI, localName, "", this._v.elementName.getNextIndex());
        entry.addQualifiedName(name);
        int namespaceURIIndex = -1;
        int prefixIndex = -1;
        if (namespaceURI.length() > 0) {
            namespaceURIIndex = this._v.namespaceName.get(namespaceURI);
            if (namespaceURIIndex == -1) {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.namespaceURINotIndexed", new Object[]{namespaceURI}));
            }
            if (prefix.length() > 0 && (prefixIndex = this._v.prefix.get(prefix)) == -1) {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.prefixNotIndexed", new Object[]{prefix}));
            }
        }
        int localNameIndex = this._v.localName.obtainIndex(localName);
        this._b |= 0x3C;
        if (namespaceURIIndex >= 0) {
            this._b |= 1;
            if (prefixIndex >= 0) {
                this._b |= 2;
            }
        }
        this.write(this._b);
        if (namespaceURIIndex >= 0) {
            if (prefixIndex >= 0) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(prefixIndex);
            }
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(namespaceURIIndex);
        }
        if (localNameIndex >= 0) {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(localNameIndex);
        } else {
            this.encodeNonEmptyOctetStringOnSecondBit(localName);
        }
    }

    protected final void encodeAttributeQualifiedNameOnSecondBit(String namespaceURI, String prefix, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(localName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            for (int i2 = 0; i2 < entry._valueIndex; ++i2) {
                if (prefix != names[i2].prefix && !prefix.equals(names[i2].prefix) || namespaceURI != names[i2].namespaceName && !namespaceURI.equals(names[i2].namespaceName)) continue;
                this.encodeNonZeroIntegerOnSecondBitFirstBitZero(names[i2].index);
                return;
            }
        }
        this.encodeLiteralAttributeQualifiedNameOnSecondBit(namespaceURI, prefix, localName, entry);
    }

    protected final boolean encodeLiteralAttributeQualifiedNameOnSecondBit(String namespaceURI, String prefix, String localName, LocalNameQualifiedNamesMap.Entry entry) throws IOException {
        int namespaceURIIndex = -1;
        int prefixIndex = -1;
        if (namespaceURI.length() > 0) {
            namespaceURIIndex = this._v.namespaceName.get(namespaceURI);
            if (namespaceURIIndex == -1) {
                if (namespaceURI == "http://www.w3.org/2000/xmlns/" || namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                    return false;
                }
                throw new IOException(CommonResourceBundle.getInstance().getString("message.namespaceURINotIndexed", new Object[]{namespaceURI}));
            }
            if (prefix.length() > 0 && (prefixIndex = this._v.prefix.get(prefix)) == -1) {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.prefixNotIndexed", new Object[]{prefix}));
            }
        }
        int localNameIndex = this._v.localName.obtainIndex(localName);
        QualifiedName name = new QualifiedName(prefix, namespaceURI, localName, "", this._v.attributeName.getNextIndex());
        entry.addQualifiedName(name);
        this._b = 120;
        if (namespaceURI.length() > 0) {
            this._b |= 1;
            if (prefix.length() > 0) {
                this._b |= 2;
            }
        }
        this.write(this._b);
        if (namespaceURIIndex >= 0) {
            if (prefixIndex >= 0) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(prefixIndex);
            }
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(namespaceURIIndex);
        } else if (namespaceURI != "") {
            this.encodeNonEmptyOctetStringOnSecondBit("xml");
            this.encodeNonEmptyOctetStringOnSecondBit("http://www.w3.org/XML/1998/namespace");
        }
        if (localNameIndex >= 0) {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(localNameIndex);
        } else {
            this.encodeNonEmptyOctetStringOnSecondBit(localName);
        }
        return true;
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(String s2, StringIntMap map, boolean addToTable, boolean mustBeAddedToTable) throws IOException {
        if (s2 == null || s2.length() == 0) {
            this.write(255);
        } else if (addToTable || mustBeAddedToTable) {
            int index;
            boolean canAddAttributeToTable = mustBeAddedToTable || this.canAddAttributeToTable(s2.length());
            int n2 = index = canAddAttributeToTable ? map.obtainIndex(s2) : map.get(s2);
            if (index != -1) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(index);
            } else if (canAddAttributeToTable) {
                this._b = 0x40 | this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(s2);
            } else {
                this._b = this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(s2);
            }
        } else {
            this._b = this._nonIdentifyingStringOnFirstBitCES;
            this.encodeNonEmptyCharacterStringOnFifthBit(s2);
        }
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(String s2, CharArrayIntMap map, boolean addToTable) throws IOException {
        if (s2 == null || s2.length() == 0) {
            this.write(255);
        } else if (addToTable) {
            int index;
            char[] ch = s2.toCharArray();
            int length = s2.length();
            boolean canAddCharacterContentToTable = this.canAddCharacterContentToTable(length, map);
            int n2 = index = canAddCharacterContentToTable ? map.obtainIndex(ch, 0, length, false) : map.get(ch, 0, length);
            if (index != -1) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(index);
            } else if (canAddCharacterContentToTable) {
                this._b = 0x40 | this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(ch, 0, length);
            } else {
                this._b = this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(s2);
            }
        } else {
            this._b = this._nonIdentifyingStringOnFirstBitCES;
            this.encodeNonEmptyCharacterStringOnFifthBit(s2);
        }
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(char[] ch, int offset, int length, CharArrayIntMap map, boolean addToTable, boolean clone) throws IOException {
        if (length == 0) {
            this.write(255);
        } else if (addToTable) {
            int index;
            boolean canAddCharacterContentToTable = this.canAddCharacterContentToTable(length, map);
            int n2 = index = canAddCharacterContentToTable ? map.obtainIndex(ch, offset, length, clone) : map.get(ch, offset, length);
            if (index != -1) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(index);
            } else if (canAddCharacterContentToTable) {
                this._b = 0x40 | this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(ch, offset, length);
            } else {
                this._b = this._nonIdentifyingStringOnFirstBitCES;
                this.encodeNonEmptyCharacterStringOnFifthBit(ch, offset, length);
            }
        } else {
            this._b = this._nonIdentifyingStringOnFirstBitCES;
            this.encodeNonEmptyCharacterStringOnFifthBit(ch, offset, length);
        }
    }

    protected final void encodeNumericNonIdentifyingStringOnFirstBit(String s2, boolean addToTable, boolean mustBeAddedToTable) throws IOException, FastInfosetException {
        this.encodeNonIdentifyingStringOnFirstBit(0, NUMERIC_CHARACTERS_TABLE, s2, addToTable, mustBeAddedToTable);
    }

    protected final void encodeDateTimeNonIdentifyingStringOnFirstBit(String s2, boolean addToTable, boolean mustBeAddedToTable) throws IOException, FastInfosetException {
        this.encodeNonIdentifyingStringOnFirstBit(1, DATE_TIME_CHARACTERS_TABLE, s2, addToTable, mustBeAddedToTable);
    }

    protected final void encodeNonIdentifyingStringOnFirstBit(int id2, int[] table, String s2, boolean addToTable, boolean mustBeAddedToTable) throws IOException, FastInfosetException {
        if (s2 == null || s2.length() == 0) {
            this.write(255);
            return;
        }
        if (addToTable || mustBeAddedToTable) {
            int index;
            boolean canAddAttributeToTable = mustBeAddedToTable || this.canAddAttributeToTable(s2.length());
            int n2 = index = canAddAttributeToTable ? this._v.attributeValue.obtainIndex(s2) : this._v.attributeValue.get(s2);
            if (index != -1) {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(index);
                return;
            }
            this._b = canAddAttributeToTable ? 96 : 32;
        } else {
            this._b = 32;
        }
        this.write(this._b | (id2 & 0xF0) >> 4);
        this._b = (id2 & 0xF) << 4;
        int length = s2.length();
        int octetPairLength = length / 2;
        int octetSingleLength = length % 2;
        this.encodeNonZeroOctetStringLengthOnFifthBit(octetPairLength + octetSingleLength);
        this.encodeNonEmptyFourBitCharacterString(table, s2.toCharArray(), 0, octetPairLength, octetSingleLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void encodeNonIdentifyingStringOnFirstBit(String URI2, int id2, Object data) throws FastInfosetException, IOException {
        if (URI2 != null) {
            id2 = this._v.encodingAlgorithm.get(URI2);
            if (id2 == -1) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.EncodingAlgorithmURI", new Object[]{URI2}));
            }
            id2 += 32;
            EncodingAlgorithm ea = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(URI2);
            if (ea != null) {
                this.encodeAIIObjectAlgorithmData(id2, data, ea);
                return;
            } else {
                if (!(data instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
                byte[] d2 = (byte[])data;
                this.encodeAIIOctetAlgorithmData(id2, d2, 0, d2.length);
            }
            return;
        } else if (id2 <= 9) {
            int length = 0;
            switch (id2) {
                case 0: 
                case 1: {
                    length = ((byte[])data).length;
                    break;
                }
                case 2: {
                    length = ((short[])data).length;
                    break;
                }
                case 3: {
                    length = ((int[])data).length;
                    break;
                }
                case 4: 
                case 8: {
                    length = ((long[])data).length;
                    break;
                }
                case 5: {
                    length = ((boolean[])data).length;
                    break;
                }
                case 6: {
                    length = ((float[])data).length;
                    break;
                }
                case 7: {
                    length = ((double[])data).length;
                    break;
                }
                case 9: {
                    throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.CDATA"));
                }
                default: {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.UnsupportedBuiltInAlgorithm", new Object[]{id2}));
                }
            }
            this.encodeAIIBuiltInAlgorithmData(id2, data, 0, length);
            return;
        } else {
            if (id2 < 32) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            if (!(data instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
            byte[] d3 = (byte[])data;
            this.encodeAIIOctetAlgorithmData(id2, d3, 0, d3.length);
        }
    }

    protected final void encodeAIIOctetAlgorithmData(int id2, byte[] d2, int offset, int length) throws IOException {
        this.write(0x30 | (id2 & 0xF0) >> 4);
        this._b = (id2 & 0xF) << 4;
        this.encodeNonZeroOctetStringLengthOnFifthBit(length);
        this.write(d2, offset, length);
    }

    protected final void encodeAIIObjectAlgorithmData(int id2, Object data, EncodingAlgorithm ea) throws FastInfosetException, IOException {
        this.write(0x30 | (id2 & 0xF0) >> 4);
        this._b = (id2 & 0xF) << 4;
        this._encodingBufferOutputStream.reset();
        ea.encodeToOutputStream(data, this._encodingBufferOutputStream);
        this.encodeNonZeroOctetStringLengthOnFifthBit(this._encodingBufferIndex);
        this.write(this._encodingBuffer, this._encodingBufferIndex);
    }

    protected final void encodeAIIBuiltInAlgorithmData(int id2, Object data, int offset, int length) throws IOException {
        this.write(0x30 | (id2 & 0xF0) >> 4);
        this._b = (id2 & 0xF) << 4;
        int octetLength = BuiltInEncodingAlgorithmFactory.getAlgorithm(id2).getOctetLengthFromPrimitiveLength(length);
        this.encodeNonZeroOctetStringLengthOnFifthBit(octetLength);
        this.ensureSize(octetLength);
        BuiltInEncodingAlgorithmFactory.getAlgorithm(id2).encodeToBytes(data, offset, length, this._octetBuffer, this._octetBufferIndex);
        this._octetBufferIndex += octetLength;
    }

    protected final void encodeNonIdentifyingStringOnThirdBit(char[] ch, int offset, int length, CharArrayIntMap map, boolean addToTable, boolean clone) throws IOException {
        if (addToTable) {
            int index;
            boolean canAddCharacterContentToTable = this.canAddCharacterContentToTable(length, map);
            int n2 = index = canAddCharacterContentToTable ? map.obtainIndex(ch, offset, length, clone) : map.get(ch, offset, length);
            if (index != -1) {
                this._b = 160;
                this.encodeNonZeroIntegerOnFourthBit(index);
            } else if (canAddCharacterContentToTable) {
                this._b = 0x10 | this._nonIdentifyingStringOnThirdBitCES;
                this.encodeNonEmptyCharacterStringOnSeventhBit(ch, offset, length);
            } else {
                this._b = this._nonIdentifyingStringOnThirdBitCES;
                this.encodeNonEmptyCharacterStringOnSeventhBit(ch, offset, length);
            }
        } else {
            this._b = this._nonIdentifyingStringOnThirdBitCES;
            this.encodeNonEmptyCharacterStringOnSeventhBit(ch, offset, length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void encodeNonIdentifyingStringOnThirdBit(String URI2, int id2, Object data) throws FastInfosetException, IOException {
        if (URI2 != null) {
            id2 = this._v.encodingAlgorithm.get(URI2);
            if (id2 == -1) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.EncodingAlgorithmURI", new Object[]{URI2}));
            }
            id2 += 32;
            EncodingAlgorithm ea = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(URI2);
            if (ea != null) {
                this.encodeCIIObjectAlgorithmData(id2, data, ea);
                return;
            } else {
                if (!(data instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
                byte[] d2 = (byte[])data;
                this.encodeCIIOctetAlgorithmData(id2, d2, 0, d2.length);
            }
            return;
        } else if (id2 <= 9) {
            int length = 0;
            switch (id2) {
                case 0: 
                case 1: {
                    length = ((byte[])data).length;
                    break;
                }
                case 2: {
                    length = ((short[])data).length;
                    break;
                }
                case 3: {
                    length = ((int[])data).length;
                    break;
                }
                case 4: 
                case 8: {
                    length = ((long[])data).length;
                    break;
                }
                case 5: {
                    length = ((boolean[])data).length;
                    break;
                }
                case 6: {
                    length = ((float[])data).length;
                    break;
                }
                case 7: {
                    length = ((double[])data).length;
                    break;
                }
                case 9: {
                    throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.CDATA"));
                }
                default: {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.UnsupportedBuiltInAlgorithm", new Object[]{id2}));
                }
            }
            this.encodeCIIBuiltInAlgorithmData(id2, data, 0, length);
            return;
        } else {
            if (id2 < 32) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
            if (!(data instanceof byte[])) throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.nullEncodingAlgorithmURI"));
            byte[] d3 = (byte[])data;
            this.encodeCIIOctetAlgorithmData(id2, d3, 0, d3.length);
        }
    }

    protected final void encodeNonIdentifyingStringOnThirdBit(String URI2, int id2, byte[] d2, int offset, int length) throws FastInfosetException, IOException {
        if (URI2 != null) {
            id2 = this._v.encodingAlgorithm.get(URI2);
            if (id2 == -1) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.EncodingAlgorithmURI", new Object[]{URI2}));
            }
            id2 += 32;
        }
        this.encodeCIIOctetAlgorithmData(id2, d2, offset, length);
    }

    protected final void encodeCIIOctetAlgorithmData(int id2, byte[] d2, int offset, int length) throws IOException {
        this.write(0x8C | (id2 & 0xC0) >> 6);
        this._b = (id2 & 0x3F) << 2;
        this.encodeNonZeroOctetStringLengthOnSenventhBit(length);
        this.write(d2, offset, length);
    }

    protected final void encodeCIIObjectAlgorithmData(int id2, Object data, EncodingAlgorithm ea) throws FastInfosetException, IOException {
        this.write(0x8C | (id2 & 0xC0) >> 6);
        this._b = (id2 & 0x3F) << 2;
        this._encodingBufferOutputStream.reset();
        ea.encodeToOutputStream(data, this._encodingBufferOutputStream);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(this._encodingBufferIndex);
        this.write(this._encodingBuffer, this._encodingBufferIndex);
    }

    protected final void encodeCIIBuiltInAlgorithmData(int id2, Object data, int offset, int length) throws FastInfosetException, IOException {
        this.write(0x8C | (id2 & 0xC0) >> 6);
        this._b = (id2 & 0x3F) << 2;
        int octetLength = BuiltInEncodingAlgorithmFactory.getAlgorithm(id2).getOctetLengthFromPrimitiveLength(length);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(octetLength);
        this.ensureSize(octetLength);
        BuiltInEncodingAlgorithmFactory.getAlgorithm(id2).encodeToBytes(data, offset, length, this._octetBuffer, this._octetBufferIndex);
        this._octetBufferIndex += octetLength;
    }

    protected final void encodeCIIBuiltInAlgorithmDataAsCDATA(char[] ch, int offset, int length) throws FastInfosetException, IOException {
        this.write(140);
        this._b = 36;
        length = this.encodeUTF8String(ch, offset, length);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(length);
        this.write(this._encodingBuffer, length);
    }

    protected final void encodeIdentifyingNonEmptyStringOnFirstBit(String s2, StringIntMap map) throws IOException {
        int index = map.obtainIndex(s2);
        if (index == -1) {
            this.encodeNonEmptyOctetStringOnSecondBit(s2);
        } else {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(index);
        }
    }

    protected final void encodeNonEmptyOctetStringOnSecondBit(String s2) throws IOException {
        int length = this.encodeUTF8String(s2);
        this.encodeNonZeroOctetStringLengthOnSecondBit(length);
        this.write(this._encodingBuffer, length);
    }

    protected final void encodeNonZeroOctetStringLengthOnSecondBit(int length) throws IOException {
        if (length < 65) {
            this.write(length - 1);
        } else if (length < 321) {
            this.write(64);
            this.write(length - 65);
        } else {
            this.write(96);
            this.write((length -= 321) >>> 24);
            this.write(length >> 16 & 0xFF);
            this.write(length >> 8 & 0xFF);
            this.write(length & 0xFF);
        }
    }

    protected final void encodeNonEmptyCharacterStringOnFifthBit(String s2) throws IOException {
        int length = this._encodingStringsAsUtf8 ? this.encodeUTF8String(s2) : this.encodeUtf16String(s2);
        this.encodeNonZeroOctetStringLengthOnFifthBit(length);
        this.write(this._encodingBuffer, length);
    }

    protected final void encodeNonEmptyCharacterStringOnFifthBit(char[] ch, int offset, int length) throws IOException {
        length = this._encodingStringsAsUtf8 ? this.encodeUTF8String(ch, offset, length) : this.encodeUtf16String(ch, offset, length);
        this.encodeNonZeroOctetStringLengthOnFifthBit(length);
        this.write(this._encodingBuffer, length);
    }

    protected final void encodeNonZeroOctetStringLengthOnFifthBit(int length) throws IOException {
        if (length < 9) {
            this.write(this._b | length - 1);
        } else if (length < 265) {
            this.write(this._b | 8);
            this.write(length - 9);
        } else {
            this.write(this._b | 0xC);
            this.write((length -= 265) >>> 24);
            this.write(length >> 16 & 0xFF);
            this.write(length >> 8 & 0xFF);
            this.write(length & 0xFF);
        }
    }

    protected final void encodeNonEmptyCharacterStringOnSeventhBit(char[] ch, int offset, int length) throws IOException {
        length = this._encodingStringsAsUtf8 ? this.encodeUTF8String(ch, offset, length) : this.encodeUtf16String(ch, offset, length);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(length);
        this.write(this._encodingBuffer, length);
    }

    protected final void encodeNonEmptyFourBitCharacterStringOnSeventhBit(int[] table, char[] ch, int offset, int length) throws FastInfosetException, IOException {
        int octetPairLength = length / 2;
        int octetSingleLength = length % 2;
        this.encodeNonZeroOctetStringLengthOnSenventhBit(octetPairLength + octetSingleLength);
        this.encodeNonEmptyFourBitCharacterString(table, ch, offset, octetPairLength, octetSingleLength);
    }

    protected final void encodeNonEmptyFourBitCharacterString(int[] table, char[] ch, int offset, int octetPairLength, int octetSingleLength) throws FastInfosetException, IOException {
        this.ensureSize(octetPairLength + octetSingleLength);
        int v2 = 0;
        for (int i2 = 0; i2 < octetPairLength; ++i2) {
            if ((v2 = table[ch[offset++]] << 4 | table[ch[offset++]]) < 0) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.characterOutofAlphabetRange"));
            }
            this._octetBuffer[this._octetBufferIndex++] = (byte)v2;
        }
        if (octetSingleLength == 1) {
            v2 = table[ch[offset]] << 4 | 0xF;
            if (v2 < 0) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.characterOutofAlphabetRange"));
            }
            this._octetBuffer[this._octetBufferIndex++] = (byte)v2;
        }
    }

    protected final void encodeNonEmptyNBitCharacterStringOnSeventhBit(String alphabet, char[] ch, int offset, int length) throws FastInfosetException, IOException {
        int bitsPerCharacter = 1;
        while (1 << bitsPerCharacter <= alphabet.length()) {
            ++bitsPerCharacter;
        }
        int bits = length * bitsPerCharacter;
        int octets = bits / 8;
        int bitsOfLastOctet = bits % 8;
        int totalOctets = octets + (bitsOfLastOctet > 0 ? 1 : 0);
        this.encodeNonZeroOctetStringLengthOnSenventhBit(totalOctets);
        this.resetBits();
        this.ensureSize(totalOctets);
        int v2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = ch[offset + i2];
            for (v2 = 0; v2 < alphabet.length() && c2 != alphabet.charAt(v2); ++v2) {
            }
            if (v2 == alphabet.length()) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.characterOutofAlphabetRange"));
            }
            this.writeBits(bitsPerCharacter, v2);
        }
        if (bitsOfLastOctet > 0) {
            this._b |= (1 << 8 - bitsOfLastOctet) - 1;
            this.write(this._b);
        }
    }

    private final void resetBits() {
        this._bitsLeftInOctet = 8;
        this._b = 0;
    }

    private final void writeBits(int bits, int v2) throws IOException {
        while (bits > 0) {
            int bit = (v2 & 1 << --bits) > 0 ? 1 : 0;
            this._b |= bit << --this._bitsLeftInOctet;
            if (this._bitsLeftInOctet != 0) continue;
            this.write(this._b);
            this._bitsLeftInOctet = 8;
            this._b = 0;
        }
    }

    protected final void encodeNonZeroOctetStringLengthOnSenventhBit(int length) throws IOException {
        if (length < 3) {
            this.write(this._b | length - 1);
        } else if (length < 259) {
            this.write(this._b | 2);
            this.write(length - 3);
        } else {
            this.write(this._b | 3);
            this.write((length -= 259) >>> 24);
            this.write(length >> 16 & 0xFF);
            this.write(length >> 8 & 0xFF);
            this.write(length & 0xFF);
        }
    }

    protected final void encodeNonZeroIntegerOnSecondBitFirstBitOne(int i2) throws IOException {
        if (i2 < 64) {
            this.write(0x80 | i2);
        } else if (i2 < 8256) {
            this._b = 0xC0 | (i2 -= 64) >> 8;
            this.write(this._b);
            this.write(i2 & 0xFF);
        } else if (i2 < 0x100000) {
            this._b = 0xE0 | (i2 -= 8256) >> 16;
            this.write(this._b);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        } else {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.integerMaxSize", new Object[]{0x100000}));
        }
    }

    protected final void encodeNonZeroIntegerOnSecondBitFirstBitZero(int i2) throws IOException {
        if (i2 < 64) {
            this.write(i2);
        } else if (i2 < 8256) {
            this._b = 0x40 | (i2 -= 64) >> 8;
            this.write(this._b);
            this.write(i2 & 0xFF);
        } else {
            this._b = 0x60 | (i2 -= 8256) >> 16;
            this.write(this._b);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        }
    }

    protected final void encodeNonZeroIntegerOnThirdBit(int i2) throws IOException {
        if (i2 < 32) {
            this.write(this._b | i2);
        } else if (i2 < 2080) {
            this._b |= 0x20 | (i2 -= 32) >> 8;
            this.write(this._b);
            this.write(i2 & 0xFF);
        } else if (i2 < 526368) {
            this._b |= 0x28 | (i2 -= 2080) >> 16;
            this.write(this._b);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        } else {
            this._b |= 0x30;
            this.write(this._b);
            this.write((i2 -= 526368) >> 16);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        }
    }

    protected final void encodeNonZeroIntegerOnFourthBit(int i2) throws IOException {
        if (i2 < 16) {
            this.write(this._b | i2);
        } else if (i2 < 1040) {
            this._b |= 0x10 | (i2 -= 16) >> 8;
            this.write(this._b);
            this.write(i2 & 0xFF);
        } else if (i2 < 263184) {
            this._b |= 0x14 | (i2 -= 1040) >> 16;
            this.write(this._b);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        } else {
            this._b |= 0x18;
            this.write(this._b);
            this.write((i2 -= 263184) >> 16);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        }
    }

    protected final void encodeNonEmptyUTF8StringAsOctetString(int b2, String s2, int[] constants) throws IOException {
        char[] ch = s2.toCharArray();
        this.encodeNonEmptyUTF8StringAsOctetString(b2, ch, 0, ch.length, constants);
    }

    protected final void encodeNonEmptyUTF8StringAsOctetString(int b2, char[] ch, int offset, int length, int[] constants) throws IOException {
        length = this.encodeUTF8String(ch, offset, length);
        this.encodeNonZeroOctetStringLength(b2, length, constants);
        this.write(this._encodingBuffer, length);
    }

    protected final void encodeNonZeroOctetStringLength(int b2, int length, int[] constants) throws IOException {
        if (length < constants[0]) {
            this.write(b2 | length - 1);
        } else if (length < constants[1]) {
            this.write(b2 | constants[2]);
            this.write(length - constants[0]);
        } else {
            this.write(b2 | constants[3]);
            this.write((length -= constants[1]) >>> 24);
            this.write(length >> 16 & 0xFF);
            this.write(length >> 8 & 0xFF);
            this.write(length & 0xFF);
        }
    }

    protected final void encodeNonZeroInteger(int b2, int i2, int[] constants) throws IOException {
        if (i2 < constants[0]) {
            this.write(b2 | i2);
        } else if (i2 < constants[1]) {
            this.write(b2 | constants[3] | (i2 -= constants[0]) >> 8);
            this.write(i2 & 0xFF);
        } else if (i2 < constants[2]) {
            this.write(b2 | constants[4] | (i2 -= constants[1]) >> 16);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        } else if (i2 < 0x100000) {
            this.write(b2 | constants[5]);
            this.write((i2 -= constants[2]) >> 16);
            this.write(i2 >> 8 & 0xFF);
            this.write(i2 & 0xFF);
        } else {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.integerMaxSize", new Object[]{0x100000}));
        }
    }

    protected final void mark() {
        this._markIndex = this._octetBufferIndex;
    }

    protected final void resetMark() {
        this._markIndex = -1;
    }

    protected final boolean hasMark() {
        return this._markIndex != -1;
    }

    protected final void write(int i2) throws IOException {
        if (this._octetBufferIndex < this._octetBuffer.length) {
            this._octetBuffer[this._octetBufferIndex++] = (byte)i2;
        } else if (this._markIndex == -1) {
            this._s.write(this._octetBuffer);
            this._octetBufferIndex = 1;
            this._octetBuffer[0] = (byte)i2;
        } else {
            this.resize(this._octetBuffer.length * 3 / 2);
            this._octetBuffer[this._octetBufferIndex++] = (byte)i2;
        }
    }

    protected final void write(byte[] b2, int length) throws IOException {
        this.write(b2, 0, length);
    }

    protected final void write(byte[] b2, int offset, int length) throws IOException {
        if (this._octetBufferIndex + length < this._octetBuffer.length) {
            System.arraycopy(b2, offset, this._octetBuffer, this._octetBufferIndex, length);
            this._octetBufferIndex += length;
        } else if (this._markIndex == -1) {
            this._s.write(this._octetBuffer, 0, this._octetBufferIndex);
            this._s.write(b2, offset, length);
            this._octetBufferIndex = 0;
        } else {
            this.resize((this._octetBuffer.length + length) * 3 / 2 + 1);
            System.arraycopy(b2, offset, this._octetBuffer, this._octetBufferIndex, length);
            this._octetBufferIndex += length;
        }
    }

    private void ensureSize(int length) {
        if (this._octetBufferIndex + length > this._octetBuffer.length) {
            this.resize((this._octetBufferIndex + length) * 3 / 2 + 1);
        }
    }

    private void resize(int length) {
        byte[] b2 = new byte[length];
        System.arraycopy(this._octetBuffer, 0, b2, 0, this._octetBufferIndex);
        this._octetBuffer = b2;
    }

    private void _flush() throws IOException {
        if (this._octetBufferIndex > 0) {
            this._s.write(this._octetBuffer, 0, this._octetBufferIndex);
            this._octetBufferIndex = 0;
        }
    }

    protected final int encodeUTF8String(String s2) throws IOException {
        int length = s2.length();
        if (length < this._charBuffer.length) {
            s2.getChars(0, length, this._charBuffer, 0);
            return this.encodeUTF8String(this._charBuffer, 0, length);
        }
        char[] ch = s2.toCharArray();
        return this.encodeUTF8String(ch, 0, length);
    }

    private void ensureEncodingBufferSizeForUtf8String(int length) {
        int newLength = 4 * length;
        if (this._encodingBuffer.length < newLength) {
            this._encodingBuffer = new byte[newLength];
        }
    }

    protected final int encodeUTF8String(char[] ch, int offset, int length) throws IOException {
        int bpos = 0;
        this.ensureEncodingBufferSizeForUtf8String(length);
        int end = offset + length;
        while (end != offset) {
            char c2;
            if ((c2 = ch[offset++]) < '\u0080') {
                this._encodingBuffer[bpos++] = (byte)c2;
                continue;
            }
            if (c2 < '\u0800') {
                this._encodingBuffer[bpos++] = (byte)(0xC0 | c2 >> 6);
                this._encodingBuffer[bpos++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 > '\uffff') continue;
            if (!XMLChar.isHighSurrogate(c2) && !XMLChar.isLowSurrogate(c2)) {
                this._encodingBuffer[bpos++] = (byte)(0xE0 | c2 >> 12);
                this._encodingBuffer[bpos++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                this._encodingBuffer[bpos++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            this.encodeCharacterAsUtf8FourByte(c2, ch, offset, end, bpos);
            bpos += 4;
            ++offset;
        }
        return bpos;
    }

    private void encodeCharacterAsUtf8FourByte(int c2, char[] ch, int chpos, int chend, int bpos) throws IOException {
        if (chpos == chend) {
            throw new IOException("");
        }
        char d2 = ch[chpos];
        if (!XMLChar.isLowSurrogate(d2)) {
            throw new IOException("");
        }
        int uc2 = ((c2 & 0x3FF) << 10 | d2 & 0x3FF) + 65536;
        if (uc2 < 0 || uc2 >= 0x200000) {
            throw new IOException("");
        }
        this._encodingBuffer[bpos++] = (byte)(0xF0 | uc2 >> 18);
        this._encodingBuffer[bpos++] = (byte)(0x80 | uc2 >> 12 & 0x3F);
        this._encodingBuffer[bpos++] = (byte)(0x80 | uc2 >> 6 & 0x3F);
        this._encodingBuffer[bpos++] = (byte)(0x80 | uc2 & 0x3F);
    }

    protected final int encodeUtf16String(String s2) throws IOException {
        int length = s2.length();
        if (length < this._charBuffer.length) {
            s2.getChars(0, length, this._charBuffer, 0);
            return this.encodeUtf16String(this._charBuffer, 0, length);
        }
        char[] ch = s2.toCharArray();
        return this.encodeUtf16String(ch, 0, length);
    }

    private void ensureEncodingBufferSizeForUtf16String(int length) {
        int newLength = 2 * length;
        if (this._encodingBuffer.length < newLength) {
            this._encodingBuffer = new byte[newLength];
        }
    }

    protected final int encodeUtf16String(char[] ch, int offset, int length) throws IOException {
        int byteLength = 0;
        this.ensureEncodingBufferSizeForUtf16String(length);
        int n2 = offset + length;
        for (int i2 = offset; i2 < n2; ++i2) {
            char c2 = ch[i2];
            this._encodingBuffer[byteLength++] = (byte)(c2 >> 8);
            this._encodingBuffer[byteLength++] = (byte)(c2 & 0xFF);
        }
        return byteLength;
    }

    public static String getPrefixFromQualifiedName(String qName) {
        int i2 = qName.indexOf(58);
        String prefix = "";
        if (i2 != -1) {
            prefix = qName.substring(0, i2);
        }
        return prefix;
    }

    public static boolean isWhiteSpace(char[] ch, int start, int length) {
        if (!XMLChar.isSpace(ch[start])) {
            return false;
        }
        int end = start + length;
        while (++start < end && XMLChar.isSpace(ch[start])) {
        }
        return start == end;
    }

    public static boolean isWhiteSpace(String s2) {
        if (!XMLChar.isSpace(s2.charAt(0))) {
            return false;
        }
        int end = s2.length();
        int start = 1;
        while (start < end && XMLChar.isSpace(s2.charAt(start++))) {
        }
        return start == end;
    }

    static /* synthetic */ byte[] access$202(Encoder x0, byte[] x1) {
        x0._encodingBuffer = x1;
        return x1;
    }

    static {
        int i2;
        _characterEncodingSchemeSystemDefault = Encoder.getDefaultEncodingScheme();
        NUMERIC_CHARACTERS_TABLE = new int[Encoder.maxCharacter("0123456789-+.E ") + 1];
        DATE_TIME_CHARACTERS_TABLE = new int[Encoder.maxCharacter("0123456789-:TZ ") + 1];
        for (i2 = 0; i2 < NUMERIC_CHARACTERS_TABLE.length; ++i2) {
            Encoder.NUMERIC_CHARACTERS_TABLE[i2] = -1;
        }
        for (i2 = 0; i2 < DATE_TIME_CHARACTERS_TABLE.length; ++i2) {
            Encoder.DATE_TIME_CHARACTERS_TABLE[i2] = -1;
        }
        for (i2 = 0; i2 < "0123456789-+.E ".length(); ++i2) {
            Encoder.NUMERIC_CHARACTERS_TABLE["0123456789-+.E ".charAt((int)i2)] = i2;
        }
        for (i2 = 0; i2 < "0123456789-:TZ ".length(); ++i2) {
            Encoder.DATE_TIME_CHARACTERS_TABLE["0123456789-:TZ ".charAt((int)i2)] = i2;
        }
    }

    private class EncodingBufferOutputStream
    extends OutputStream {
        private EncodingBufferOutputStream() {
        }

        public void write(int b2) throws IOException {
            if (Encoder.this._encodingBufferIndex < Encoder.this._encodingBuffer.length) {
                ((Encoder)Encoder.this)._encodingBuffer[((Encoder)Encoder.this)._encodingBufferIndex++] = (byte)b2;
            } else {
                byte[] newbuf = new byte[Math.max(Encoder.this._encodingBuffer.length << 1, Encoder.this._encodingBufferIndex)];
                System.arraycopy(Encoder.this._encodingBuffer, 0, newbuf, 0, Encoder.this._encodingBufferIndex);
                Encoder.access$202(Encoder.this, newbuf);
                ((Encoder)Encoder.this)._encodingBuffer[((Encoder)Encoder.this)._encodingBufferIndex++] = (byte)b2;
            }
        }

        public void write(byte[] b2, int off, int len) throws IOException {
            if (off < 0 || off > b2.length || len < 0 || off + len > b2.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int newoffset = Encoder.this._encodingBufferIndex + len;
            if (newoffset > Encoder.this._encodingBuffer.length) {
                byte[] newbuf = new byte[Math.max(Encoder.this._encodingBuffer.length << 1, newoffset)];
                System.arraycopy(Encoder.this._encodingBuffer, 0, newbuf, 0, Encoder.this._encodingBufferIndex);
                Encoder.access$202(Encoder.this, newbuf);
            }
            System.arraycopy(b2, off, Encoder.this._encodingBuffer, Encoder.this._encodingBufferIndex, len);
            Encoder.this._encodingBufferIndex = newoffset;
        }

        public int getLength() {
            return Encoder.this._encodingBufferIndex;
        }

        public void reset() {
            Encoder.this._encodingBufferIndex = 0;
        }
    }
}

