/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import java.util.Enumeration;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMScanner
implements LocatorEx,
InfosetScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private Locator locator = this;

    public void setLocator(Locator loc) {
        this.locator = loc;
    }

    public void scan(Object node) throws SAXException {
        if (node instanceof Document) {
            this.scan((Document)node);
        } else {
            this.scan((Element)node);
        }
    }

    public void scan(Document doc) throws SAXException {
        this.scan(doc.getDocumentElement());
    }

    public void scan(Element e2) throws SAXException {
        String prefix;
        this.setCurrentLocation(e2);
        this.receiver.setDocumentLocator(this.locator);
        this.receiver.startDocument();
        NamespaceSupport nss = new NamespaceSupport();
        this.buildNamespaceSupport(nss, e2.getParentNode());
        Enumeration<String> en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            prefix = en.nextElement();
            this.receiver.startPrefixMapping(prefix, nss.getURI(prefix));
        }
        this.visit(e2);
        en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            prefix = en.nextElement();
            this.receiver.endPrefixMapping(prefix);
        }
        this.setCurrentLocation(e2);
        this.receiver.endDocument();
    }

    public void parse(Element e2, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e2);
        this.receiver.startDocument();
        this.receiver.setDocumentLocator(this.locator);
        this.visit(e2);
        this.setCurrentLocation(e2);
        this.receiver.endDocument();
    }

    public void parseWithContext(Element e2, ContentHandler handler) throws SAXException {
        this.setContentHandler(handler);
        this.scan(e2);
    }

    private void buildNamespaceSupport(NamespaceSupport nss, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(nss, node.getParentNode());
        nss.pushContext();
        NamedNodeMap atts = node.getAttributes();
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            Attr a2 = (Attr)atts.item(i2);
            if ("xmlns".equals(a2.getPrefix())) {
                nss.declarePrefix(a2.getLocalName(), a2.getValue());
                continue;
            }
            if (!"xmlns".equals(a2.getName())) continue;
            nss.declarePrefix("", a2.getValue());
        }
    }

    public void visit(Element e2) throws SAXException {
        int i2;
        this.setCurrentLocation(e2);
        NamedNodeMap attributes = e2.getAttributes();
        this.atts.clear();
        int len = attributes == null ? 0 : attributes.getLength();
        for (int i3 = len - 1; i3 >= 0; --i3) {
            String local;
            Attr a2 = (Attr)attributes.item(i3);
            String name = a2.getName();
            if (name.startsWith("xmlns")) {
                if (name.length() == 5) {
                    this.receiver.startPrefixMapping("", a2.getValue());
                    continue;
                }
                String localName = a2.getLocalName();
                if (localName == null) {
                    localName = name.substring(6);
                }
                this.receiver.startPrefixMapping(localName, a2.getValue());
                continue;
            }
            String uri = a2.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            if ((local = a2.getLocalName()) == null) {
                local = a2.getName();
            }
            this.atts.addAttribute(uri, local, a2.getName(), "CDATA", a2.getValue());
        }
        String uri = e2.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String local = e2.getLocalName();
        String qname = e2.getTagName();
        if (local == null) {
            local = qname;
        }
        this.receiver.startElement(uri, local, qname, this.atts);
        NodeList children = e2.getChildNodes();
        int clen = children.getLength();
        for (i2 = 0; i2 < clen; ++i2) {
            this.visit(children.item(i2));
        }
        this.setCurrentLocation(e2);
        this.receiver.endElement(uri, local, qname);
        for (i2 = len - 1; i2 >= 0; --i2) {
            Attr a3 = (Attr)attributes.item(i2);
            String name = a3.getName();
            if (!name.startsWith("xmlns")) continue;
            if (name.length() == 5) {
                this.receiver.endPrefixMapping("");
                continue;
            }
            this.receiver.endPrefixMapping(a3.getLocalName());
        }
    }

    private void visit(Node n2) throws SAXException {
        this.setCurrentLocation(n2);
        switch (n2.getNodeType()) {
            case 3: 
            case 4: {
                String value = n2.getNodeValue();
                this.receiver.characters(value.toCharArray(), 0, value.length());
                break;
            }
            case 1: {
                this.visit((Element)n2);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(n2.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n2;
                this.receiver.processingInstruction(pi.getTarget(), pi.getData());
            }
        }
    }

    private void setCurrentLocation(Node currNode) {
        this.currentNode = currNode;
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }

    public Object getCurrentElement() {
        return this.currentNode;
    }

    @Override
    public LocatorEx getLocator() {
        return this;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.receiver = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.receiver;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public ValidationEventLocator getLocation() {
        return new ValidationEventLocatorImpl(this.getCurrentLocation());
    }
}

