/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.localization;

import com.sun.istack.localization.Localizable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private final Locale _locale;
    private final HashMap _resourceBundles;

    public Localizer() {
        this(Locale.getDefault());
    }

    public Localizer(Locale l2) {
        this._locale = l2;
        this._resourceBundles = new HashMap();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String localize(Localizable l2) {
        String key = l2.getKey();
        if (key == "\u0000") {
            return (String)l2.getArguments()[0];
        }
        String bundlename = l2.getResourceBundleName();
        try {
            String msg;
            ResourceBundle bundle = (ResourceBundle)this._resourceBundles.get(bundlename);
            if (bundle == null) {
                block15: {
                    try {
                        bundle = ResourceBundle.getBundle(bundlename, this._locale);
                    }
                    catch (MissingResourceException e2) {
                        int i2 = bundlename.lastIndexOf(46);
                        if (i2 == -1) break block15;
                        String alternateBundleName = bundlename.substring(i2 + 1);
                        try {
                            bundle = ResourceBundle.getBundle(alternateBundleName, this._locale);
                        }
                        catch (MissingResourceException e22) {
                            try {
                                bundle = ResourceBundle.getBundle(bundlename, this._locale, Thread.currentThread().getContextClassLoader());
                            }
                            catch (MissingResourceException e3) {
                                return this.getDefaultMessage(l2);
                            }
                        }
                    }
                }
                this._resourceBundles.put(bundlename, bundle);
            }
            if (bundle == null) {
                return this.getDefaultMessage(l2);
            }
            if (key == null) {
                key = "undefined";
            }
            try {
                msg = bundle.getString(key);
            }
            catch (MissingResourceException e3) {
                msg = bundle.getString("undefined");
            }
            Object[] args = l2.getArguments();
            for (int i3 = 0; i3 < args.length; ++i3) {
                if (!(args[i3] instanceof Localizable)) continue;
                args[i3] = this.localize((Localizable)args[i3]);
            }
            String message = MessageFormat.format(msg, args);
            return message;
        }
        catch (MissingResourceException e4) {
            return this.getDefaultMessage(l2);
        }
    }

    private String getDefaultMessage(Localizable l2) {
        String key = l2.getKey();
        Object[] args = l2.getArguments();
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[failed to localize] ");
        sb2.append(key);
        if (args != null) {
            sb2.append('(');
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (i2 != 0) {
                    sb2.append(", ");
                }
                sb2.append(String.valueOf(args[i2]));
            }
            sb2.append(')');
        }
        return sb2.toString();
    }
}

