/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.widgets.plaf;

import com.jtechdev.widgets.plaf.EPTabbedPaneUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class EPTabPainter {
    private CloseButtonLocation fCloseButtonLocation = CloseButtonLocation.LEFT;
    private CloseButtonIcon fCloseButtonIcon = new DefaultCloseButtonIcon();
    private static final int CONTENT_DISTANCE_FROM_EDGE = 5;
    private static final int CLOSE_BUTTON_DISTANCE_FROM_EDGE = 5;
    private static final int CLOSE_BUTTON_DISTANCE_FROM_CONTENT = 3;
    private static final Rectangle ADJUSTED_TAB_BOUNDS = new Rectangle();
    private static final Rectangle TEXT_BOUNDS = new Rectangle();
    private static final Rectangle ICON_BOUNDS = new Rectangle();
    static final Color SELECTED_BORDER_COLOR = new Color(0x666666);
    private static final Color UNSELECTED_BORDER_COLOR = new Color(0x888888);
    private static final Color SELECTED_BACKGROUND_COLOR = Color.WHITE;
    private static final Color UNSELECTED_BACKGROUND_COLOR = new Color(0xCCCCCC);
    private static final int CORNER_ARC_DIAMETER = 6;

    public void setCloseButtonLocation(CloseButtonLocation closeButtonLocation) {
        this.fCloseButtonLocation = closeButtonLocation;
    }

    public void paintTab(Graphics2D graphics, JTabbedPane tabPane, Rectangle tabBounds, String tabText, Icon tabIcon, boolean isSelected, boolean isMouseOverCloseButton, boolean isMousePressedOverCloseButton) {
        this.paintTabBackgroundAndBorder(graphics, tabBounds, isSelected);
        this.paintCloseButton(graphics, tabBounds, isSelected, isMouseOverCloseButton, isMousePressedOverCloseButton);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int closeButtonWidth = this.fCloseButtonIcon.getWidth();
        int textWidth = fontMetrics.stringWidth(tabText);
        int widthRequiredForCloseButton = this.fCloseButtonLocation.calculateWidthRequiredForCloseButton(closeButtonWidth);
        boolean tooWide = textWidth > tabBounds.width - widthRequiredForCloseButton - 5;
        Rectangle adjustedTabRect = new Rectangle();
        adjustedTabRect.x = tooWide ? this.fCloseButtonLocation.calculateContentX(tabBounds, closeButtonWidth) : tabBounds.x;
        adjustedTabRect.y = tabBounds.y;
        adjustedTabRect.width = tooWide ? tabBounds.width - widthRequiredForCloseButton - 5 : tabBounds.width;
        adjustedTabRect.height = tabBounds.height;
        EPTabPainter.ICON_BOUNDS.x = 0;
        EPTabPainter.ICON_BOUNDS.y = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(tabPane, fontMetrics, tabText, tabIcon, 0, 0, 0, 11, adjustedTabRect, ICON_BOUNDS, TEXT_BOUNDS, 4);
        int textX = this.fCloseButtonLocation.adjustXToPreventEncroachment(tabBounds, closeButtonWidth, TEXT_BOUNDS);
        int textY = EPTabPainter.TEXT_BOUNDS.y + fontMetrics.getAscent();
        graphics.setColor(tabPane.getForeground());
        BasicGraphicsUtils.drawString(graphics, clippedText, -1, textX, textY);
    }

    private void paintTabBackgroundAndBorder(Graphics2D graphics, Rectangle tabBounds, boolean isSelected) {
        int extendedHeight = tabBounds.height + 3;
        graphics.setColor(isSelected ? SELECTED_BACKGROUND_COLOR : UNSELECTED_BACKGROUND_COLOR);
        graphics.fillRoundRect(tabBounds.x, tabBounds.y, tabBounds.width, extendedHeight, 6, 6);
        graphics.setColor(isSelected ? SELECTED_BORDER_COLOR : UNSELECTED_BORDER_COLOR);
        graphics.drawRoundRect(tabBounds.x, tabBounds.y, tabBounds.width, extendedHeight, 6, 6);
    }

    private void paintCloseButton(Graphics2D graphics, Rectangle tabBounds, boolean isSelected, boolean isMouseOverCloseButton, boolean isMousePressedOverCloseButton) {
        int x2 = this.fCloseButtonLocation.calculateCloseButtonX(tabBounds, this.fCloseButtonIcon.getWidth());
        int y2 = this.fCloseButtonLocation.calculateCloseButtonY(tabBounds, this.fCloseButtonIcon.getHeight());
        ImageIcon closeImageIcon = this.fCloseButtonIcon.getImageIcon(isSelected, isMouseOverCloseButton, isMousePressedOverCloseButton);
        graphics.drawImage(closeImageIcon.getImage(), x2, y2, null);
    }

    public boolean isPointOverCloseButton(Rectangle tabBounds, Point point) {
        int closeButtonWidth = this.fCloseButtonIcon.getWidth();
        int closeButtonHeight = this.fCloseButtonIcon.getHeight();
        int closeButtonX = this.fCloseButtonLocation.calculateCloseButtonX(tabBounds, closeButtonWidth);
        int closeButtonY = this.fCloseButtonLocation.calculateCloseButtonY(tabBounds, closeButtonHeight);
        boolean overHorizontally = closeButtonX <= point.x && point.x <= closeButtonX + closeButtonWidth;
        boolean overVertically = closeButtonY <= point.y && point.y <= closeButtonY + closeButtonHeight;
        return overHorizontally && overVertically;
    }

    private Shape createTabShape(Rectangle tabBounds) {
        int topIndent = 3;
        int topCurveRadius = 3;
        int bottomCurveRadius = 4;
        int topLeftX = tabBounds.x + topIndent;
        int topRightX = tabBounds.x + tabBounds.width - topIndent;
        int bottomLeftX = tabBounds.x;
        int bottomRightX = tabBounds.x + tabBounds.width;
        GeneralPath path = new GeneralPath();
        path.moveTo(topLeftX + topCurveRadius, tabBounds.y);
        path.quadTo(topLeftX, tabBounds.y, topLeftX, tabBounds.y + topCurveRadius);
        path.quadTo(topLeftX, tabBounds.y + tabBounds.height, bottomLeftX, tabBounds.y + tabBounds.height);
        path.lineTo(bottomRightX, tabBounds.y + tabBounds.height);
        path.quadTo(topRightX, tabBounds.y + tabBounds.height, topRightX, tabBounds.y + topCurveRadius);
        path.quadTo(topRightX, tabBounds.y, topRightX - topCurveRadius, tabBounds.y);
        path.closePath();
        return path;
    }

    private static class DefaultCloseButtonIcon
    implements CloseButtonIcon {
        private ImageIcon fSelected = DefaultCloseButtonIcon.createImageIcon("close.png");
        private ImageIcon fUnselected = DefaultCloseButtonIcon.createImageIcon("close_unselected.png");
        private ImageIcon fOver = DefaultCloseButtonIcon.createImageIcon("close_over.png");
        private ImageIcon fPressed = DefaultCloseButtonIcon.createImageIcon("close_pressed.png");

        private DefaultCloseButtonIcon() {
        }

        @Override
        public int getWidth() {
            return this.fSelected.getIconWidth();
        }

        @Override
        public int getHeight() {
            return this.fSelected.getIconHeight();
        }

        @Override
        public ImageIcon getImageIcon(boolean isSelected, boolean isOver, boolean isPressed) {
            ImageIcon closeImageIcon = isOver && isPressed ? this.fPressed : (isOver ? this.fOver : (isSelected ? this.fSelected : this.fUnselected));
            return closeImageIcon;
        }

        private static ImageIcon createImageIcon(String fileName) {
            return new ImageIcon(EPTabbedPaneUI.class.getResource("/com.jtechdev/widgets/images/" + fileName));
        }
    }

    private static interface CloseButtonIcon {
        public int getWidth();

        public int getHeight();

        public ImageIcon getImageIcon(boolean var1, boolean var2, boolean var3);
    }

    public static enum CloseButtonLocation {
        LEFT{

            @Override
            int calculateCloseButtonX(Rectangle tabBounds, int closeButtonWidth) {
                return tabBounds.x + 5;
            }

            @Override
            int calculateContentX(Rectangle tabBounds, int closeButtonWidth) {
                return tabBounds.x + this.calculateWidthRequiredForCloseButton(closeButtonWidth);
            }

            @Override
            int adjustXToPreventEncroachment(Rectangle tabBounds, int closeButtonWidth, Rectangle contentBounds) {
                int closeButtonX = this.calculateCloseButtonX(tabBounds, closeButtonWidth);
                int closeButtonXWithPad = closeButtonX + closeButtonWidth + 3;
                return Math.max(closeButtonXWithPad, contentBounds.x);
            }
        }
        ,
        RIGHT{

            @Override
            int calculateCloseButtonX(Rectangle tabBounds, int closeButtonWidth) {
                return tabBounds.x + tabBounds.width - 3 - closeButtonWidth;
            }

            @Override
            int calculateContentX(Rectangle tabBounds, int closeButtonWidth) {
                return tabBounds.x + 5;
            }

            @Override
            int adjustXToPreventEncroachment(Rectangle tabBounds, int closeButtonWidth, Rectangle contentBounds) {
                int closeButtonX = this.calculateCloseButtonX(tabBounds, closeButtonWidth);
                int closeButtonXWithPad = closeButtonX - 3;
                int shiftAmount = contentBounds.x + contentBounds.width - closeButtonXWithPad;
                return shiftAmount > 0 ? contentBounds.x - shiftAmount : contentBounds.x;
            }
        };


        abstract int calculateCloseButtonX(Rectangle var1, int var2);

        abstract int calculateContentX(Rectangle var1, int var2);

        abstract int adjustXToPreventEncroachment(Rectangle var1, int var2, Rectangle var3);

        private int calculateCloseButtonY(Rectangle tabBounds, int closeButtonHeight) {
            return tabBounds.y + tabBounds.height / 2 - closeButtonHeight / 2;
        }

        int calculateWidthRequiredForCloseButton(int closeButtonWidth) {
            return closeButtonWidth + 5 + 3;
        }
    }
}

