/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.widgets.plaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class EPComboPopup
implements ComboPopup {
    private final JComboBox fComboBox;
    private JPopupMenu fPopupMenu = new JPopupMenu();
    private Font fFont;
    private ComboBoxVerticalCenterProvider fComboBoxVerticalCenterProvider = new DefaultVerticalCenterProvider();
    private static final int LEFT_SHIFT = 5;

    public EPComboPopup(JComboBox comboBox) {
        this.fComboBox = comboBox;
        this.fFont = comboBox.getFont();
        this.fPopupMenu.addPopupMenuListener(this.createPopupMenuListener());
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                EPComboPopup.this.fComboBox.firePopupMenuWillBecomeVisible();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                EPComboPopup.this.fComboBox.firePopupMenuWillBecomeInvisible();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
                EPComboPopup.this.fComboBox.firePopupMenuCanceled();
            }
        };
    }

    public void setFont(Font font) {
        this.fFont = font;
    }

    public void setVerticalComponentCenterProvider(ComboBoxVerticalCenterProvider comboBoxVerticalCenterProvider) {
        if (comboBoxVerticalCenterProvider == null) {
            throw new IllegalArgumentException("The given CompnonentCenterProvider cannot be null.");
        }
        this.fComboBoxVerticalCenterProvider = comboBoxVerticalCenterProvider;
    }

    private void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void clearAndFillMenu() {
        this.fPopupMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i2 = 0; i2 < this.fComboBox.getModel().getSize(); ++i2) {
            Object item = this.fComboBox.getModel().getElementAt(i2);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(item.toString());
            menuItem.setFont(this.fFont);
            menuItem.addActionListener(this.createMenuItemListener(item));
            buttonGroup.add(menuItem);
            this.fPopupMenu.add(menuItem);
            if (!item.equals(this.fComboBox.getModel().getSelectedItem())) continue;
            menuItem.setSelected(true);
            this.fPopupMenu.setSelected(menuItem);
        }
        this.fPopupMenu.pack();
        int popupWidth = this.fComboBox.getWidth() + 5;
        this.fPopupMenu.setSize(popupWidth, this.fPopupMenu.getHeight());
    }

    private Point placePopupOnScreen() {
        int buttonRightX = this.fComboBox.getWidth();
        Insets insets = this.fPopupMenu.getInsets();
        int x2 = buttonRightX - this.fPopupMenu.getPreferredSize().width - 5;
        int selectedItemIndex = this.fPopupMenu.getSelectionModel().getSelectedIndex();
        int componentCenter = this.fComboBoxVerticalCenterProvider.provideCenter(this.fComboBox);
        int menuItemHeight = this.fPopupMenu.getComponent((int)selectedItemIndex).getPreferredSize().height;
        int menuItemCenter = insets.top + selectedItemIndex * menuItemHeight + menuItemHeight / 2;
        int y2 = componentCenter - menuItemCenter;
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Point bottomOfMenuOnScreen = new Point(0, y2 + this.fPopupMenu.getPreferredSize().height);
        SwingUtilities.convertPointToScreen(bottomOfMenuOnScreen, this.fComboBox);
        if (bottomOfMenuOnScreen.y > size.height) {
            y2 = this.fComboBox.getHeight() - this.fPopupMenu.getPreferredSize().height;
        }
        return new Point(x2, y2);
    }

    private ActionListener createMenuItemListener(final Object comboBoxItem) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EPComboPopup.this.fComboBox.setSelectedItem(comboBoxItem);
            }
        };
    }

    private void forceCorrectPopupSelectionIfNeccessary() {
        if (this.fComboBox.getSelectedIndex() >= 0) {
            this.forceCorrectPopupSelection();
        }
    }

    private void forceCorrectPopupSelection() {
        assert (this.fPopupMenu.isShowing()) : "The popup must be showing for this method to work properly.";
        int index = this.fPopupMenu.getSelectionModel().getSelectedIndex();
        MenuElement[] menuPath = new MenuElement[]{this.fPopupMenu, this.fPopupMenu.getSubElements()[index]};
        MenuSelectionManager.defaultManager().setSelectedPath(menuPath);
    }

    @Override
    public void show() {
        this.clearAndFillMenu();
        if (this.fComboBox.getModel().getSize() > 0) {
            Rectangle popupBounds = this.calculateInitialPopupBounds();
            this.fPopupMenu.show(this.fComboBox, popupBounds.x, popupBounds.y);
            this.forceCorrectPopupSelectionIfNeccessary();
        }
    }

    @Override
    public void hide() {
        this.fPopupMenu.setVisible(false);
    }

    @Override
    public boolean isVisible() {
        return this.fPopupMenu.isVisible();
    }

    public JList getList() {
        return null;
    }

    @Override
    public MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (EPComboPopup.this.fComboBox.isEnabled()) {
                    EPComboPopup.this.togglePopup();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                MenuSelectionManager.defaultManager().processMouseEvent(e2);
            }
        };
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                MenuSelectionManager.defaultManager().processMouseEvent(e2);
            }
        };
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
    }

    private Rectangle calculateInitialPopupBounds() {
        int comboBoxRightEdge = this.fComboBox.getWidth();
        Insets insets = this.fPopupMenu.getInsets();
        int x2 = comboBoxRightEdge - this.fPopupMenu.getPreferredSize().width - 5;
        int selectedItemIndex = this.fPopupMenu.getSelectionModel().getSelectedIndex();
        int componentCenter = this.fComboBoxVerticalCenterProvider.provideCenter(this.fComboBox);
        int menuItemHeight = this.fPopupMenu.getSelectionModel().getSelectedIndex() >= 0 ? this.fPopupMenu.getComponent((int)selectedItemIndex).getPreferredSize().height : 0;
        int menuItemCenter = insets.top + selectedItemIndex * menuItemHeight + menuItemHeight / 2;
        int y2 = componentCenter - menuItemCenter;
        Rectangle bounds = new Rectangle(new Point(x2, y2), this.fPopupMenu.getPreferredSize());
        Dimension preferredSize = this.fPopupMenu.getPreferredSize();
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Point bottomOfMenuOnScreen = new Point(0, y2 + preferredSize.height);
        SwingUtilities.convertPointToScreen(bottomOfMenuOnScreen, this.fComboBox);
        if (bottomOfMenuOnScreen.y > size.height) {
            y2 = this.fComboBox.getHeight() - preferredSize.height;
        }
        Point position = new Point(x2, y2);
        return bounds;
    }

    private static class DefaultVerticalCenterProvider
    implements ComboBoxVerticalCenterProvider {
        private DefaultVerticalCenterProvider() {
        }

        @Override
        public int provideCenter(JComboBox comboBox) {
            return comboBox.getHeight() / 2;
        }
    }

    public static interface ComboBoxVerticalCenterProvider {
        public int provideCenter(JComboBox var1);
    }
}

