/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.widgets;

import com.jtechdev.widgets.StripedViewportBorder;
import com.jtechdev.widgets.TableHeaderUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableColumnModel;

public class TableUtils {
    private TableUtils() {
    }

    public static void makeStriped(JTable table, Color stipeColor) {
        table.addPropertyChangeListener("ancestor", TableUtils.createAncestorPropertyChangeListener(table, stipeColor));
        for (int i2 = 0; i2 < table.getColumnModel().getColumnCount(); ++i2) {
            table.getColumnModel().getColumn(i2).addPropertyChangeListener(TableUtils.createAncestorPropertyChangeListener(table, stipeColor));
        }
    }

    private static PropertyChangeListener createAncestorPropertyChangeListener(final JTable table, final Color stipeColor) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                TableUtils.parentDidChange(table, stipeColor);
            }
        };
    }

    private static void parentDidChange(JTable table, Color stipeColor) {
        if (table.getParent() instanceof JViewport && table.getParent().getParent() instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)table.getParent().getParent();
            scrollPane.setViewportBorder(new StripedViewportBorder(scrollPane.getViewport(), table, stipeColor));
            scrollPane.getViewport().setOpaque(false);
            scrollPane.setCorner("UPPER_RIGHT_CORNER", TableHeaderUtils.createCornerComponent(table));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public static void makeSortable(JTable table, SortDelegate sortDelegate) {
        TableUtils.validateSortDelegate(sortDelegate);
        ColumnHeaderMouseListener mouseListener = new ColumnHeaderMouseListener(table, sortDelegate);
        table.getTableHeader().addMouseListener(mouseListener);
    }

    private static void validateSortDelegate(SortDelegate sortDelegate) {
        if (sortDelegate == null) {
            throw new IllegalArgumentException("The given SortDelegate cannot be null.");
        }
    }

    private static class ColumnHeaderMouseListener
    extends MouseAdapter {
        private final JTable fTable;
        private final SortDelegate fSortDelegate;
        private boolean fMouseEventIsPerformingPopupTrigger = false;

        private ColumnHeaderMouseListener(JTable fTable, SortDelegate fSortDelegate) {
            this.fTable = fTable;
            this.fSortDelegate = fSortDelegate;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.shouldProcessMouseClicked()) {
                TableColumnModel columnModel = this.fTable.getColumnModel();
                int columnViewIndex = columnModel.getColumnIndexAtX(mouseEvent.getX());
                int columnModelIndex = this.fTable.convertColumnIndexToModel(columnViewIndex);
                SortDirection sortDirection = TableHeaderUtils.toggleSortDirection(this.fTable.getTableHeader(), columnModelIndex);
                this.fSortDelegate.sort(columnModelIndex, sortDirection);
                this.fTable.getTableHeader().repaint();
            }
        }

        private boolean shouldProcessMouseClicked() {
            return !this.fMouseEventIsPerformingPopupTrigger && this.isNotResizeCursor();
        }

        private boolean isNotResizeCursor() {
            return this.fTable.getTableHeader().getCursor() != Cursor.getPredefinedCursor(11);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.fMouseEventIsPerformingPopupTrigger = mouseEvent.isPopupTrigger();
            if (this.isNotResizeCursor()) {
                TableColumnModel columnModel = this.fTable.getColumnModel();
                int viewColumnIndex = columnModel.getColumnIndexAtX(mouseEvent.getX());
                int columnModelIndex = this.fTable.convertColumnIndexToModel(viewColumnIndex);
                TableHeaderUtils.setPressedColumn(this.fTable.getTableHeader(), columnModelIndex);
                this.fTable.getTableHeader().repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            TableHeaderUtils.setPressedColumn(this.fTable.getTableHeader(), -1);
            this.fTable.getTableHeader().repaint();
        }
    }

    public static interface SortDelegate {
        public void sort(int var1, SortDirection var2);
    }

    public static enum SortDirection {
        NONE(""),
        ASCENDING("ascending"),
        DESCENDING("descending");

        private final String fValue;

        private SortDirection(String value) {
            this.fValue = value;
        }

        String getValue() {
            return this.fValue;
        }

        static SortDirection find(String value) {
            for (SortDirection sortDirection : SortDirection.values()) {
                if (!sortDirection.getValue().equals(value)) continue;
                return sortDirection;
            }
            throw new IllegalArgumentException("No sort direction found for " + value);
        }
    }
}

