/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets.plaf;

import com.jtechdev.macwidgets.MacColorUtils;
import com.jtechdev.macwidgets.MacFontUtils;
import com.jtechdev.macwidgets.plaf.EmphasizedLabelUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class UnifiedToolbarButtonUI
extends BasicButtonUI {
    private static final Color PRESSED_BUTTON_MASK_COLOR = new Color(0, 0, 0, 128);
    private static final Color DISABLED_BUTTON_MASK_COLOR = new Color(255, 255, 255, 128);

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setHorizontalTextPosition(0);
        b2.setVerticalTextPosition(3);
        b2.setIconTextGap(0);
        b2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        b2.setOpaque(false);
        b2.setFocusable(false);
        b2.setFont(MacFontUtils.DEFAULT_BUTTON_FONT);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
    }

    @Override
    protected void paintIcon(Graphics g2, JComponent c2, Rectangle iconRect) {
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        BufferedImage image = new BufferedImage(iconRect.width, iconRect.height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        b2.getIcon().paintIcon(c2, graphics, 0, 0);
        graphics.setComposite(AlphaComposite.SrcAtop);
        if (!model.isEnabled()) {
            graphics.setColor(DISABLED_BUTTON_MASK_COLOR);
        } else if (model.isArmed()) {
            graphics.setColor(PRESSED_BUTTON_MASK_COLOR);
        } else {
            graphics.setColor(new Color(0, 0, 0, 0));
        }
        graphics.fillRect(0, 0, iconRect.width, iconRect.height);
        graphics.dispose();
        g2.drawImage(image, iconRect.x, iconRect.y, null);
    }

    @Override
    protected void paintText(Graphics g2, JComponent c2, Rectangle textRect, String text) {
        MacFontUtils.enableAntialiasing((Graphics2D)g2);
        Graphics2D graphics = (Graphics2D)g2.create();
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        FontMetrics fm = c2.getFontMetrics(c2.getFont());
        graphics.setColor(model.isArmed() ? MacColorUtils.EMPTY_COLOR : EmphasizedLabelUI.DEFAULT_EMPHASIS_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, -1, textRect.x, textRect.y + 1 + fm.getAscent());
        graphics.setColor(model.isEnabled() ? EmphasizedLabelUI.DEFAULT_FOCUSED_FONT_COLOR : EmphasizedLabelUI.DEFAULT_DISABLED_FONT_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, -1, textRect.x, textRect.y + fm.getAscent());
        graphics.dispose();
    }
}

