/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets.plaf;

import com.jtechdev.macwidgets.HudWidgetFactory;
import com.jtechdev.macwidgets.WidgetBaseColors;
import com.jtechdev.macwidgets.plaf.HudButtonUI;
import com.jtechdev.macwidgets.plaf.HudPaintingUtils;
import com.jtechdev.widgets.plaf.EPComboPopup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class HudComboBoxUI
extends BasicComboBoxUI {
    private HudButtonUI fArrowButtonUI;
    private ActionListener fSelectedItemChangedActionListener = this.createSelectedItemChangedActionListener();
    private PopupMenuListener fPopupMenuListener = this.createPopupMenuListener();
    private static final int LEFT_MARGIN = 7;
    private static final int RIGHT_MARGIN = 19;
    private static final int DEFAULT_WIDTH = 100;
    private boolean isDarkColorScheme = true;

    public HudComboBoxUI() {
        this.fArrowButtonUI = new HudButtonUI(HudPaintingUtils.Roundedness.COMBO_BUTTON, this);
    }

    public HudComboBoxUI(boolean isDarkColorScheme) {
        this.isDarkColorScheme = isDarkColorScheme;
        this.fArrowButtonUI = new HudButtonUI(HudPaintingUtils.Roundedness.COMBO_BUTTON, this, this.isDarkColorScheme);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        HudPaintingUtils.initHudComponent(this.comboBox, this.isDarkColorScheme);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.addActionListener(this.createComboBoxListener());
        this.comboBox.addActionListener(this.fSelectedItemChangedActionListener);
        this.comboBox.addPopupMenuListener(this.fPopupMenuListener);
    }

    @Override
    protected void uninstallListeners() {
        this.comboBox.removeActionListener(this.fSelectedItemChangedActionListener);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.updateDisplayedItem();
    }

    private ActionListener createSelectedItemChangedActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                HudComboBoxUI.this.updateDisplayedItem();
            }
        };
    }

    private void updateDisplayedItem() {
        String displayValue = this.comboBox.getSelectedItem() == null ? " " : this.comboBox.getSelectedItem().toString();
        this.arrowButton.setText(displayValue);
        this.comboBox.invalidate();
    }

    private EPComboPopup.ComboBoxVerticalCenterProvider createComboBoxVerticalCenterProvider() {
        return new EPComboPopup.ComboBoxVerticalCenterProvider(){

            @Override
            public int provideCenter(JComboBox comboBox) {
                return HudComboBoxUI.this.calculateArrowButtonVisualVerticalCenter();
            }
        };
    }

    private ActionListener createComboBoxListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                HudComboBoxUI.this.updateDisplayedItem();
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                HudComboBoxUI.this.arrowButton.getModel().setPressed(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                HudComboBoxUI.this.arrowButton.getModel().setPressed(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
            }
        };
    }

    @Override
    protected JButton createArrowButton() {
        JButton arrowButton = new JButton("");
        arrowButton.setModel(this.createButtonModel());
        arrowButton.setUI(this.fArrowButtonUI);
        Insets currentInsets = arrowButton.getInsets();
        arrowButton.setBorder(BorderFactory.createEmptyBorder(currentInsets.top, 7, currentInsets.bottom, 19));
        arrowButton.setHorizontalAlignment(2);
        return arrowButton;
    }

    private ButtonModel createButtonModel() {
        return new DefaultButtonModel(){

            @Override
            public boolean isPressed() {
                return super.isPressed() || HudComboBoxUI.this.isPopupVisible(HudComboBoxUI.this.comboBox);
            }
        };
    }

    protected ListCellRenderer createRenderer() {
        return new JComboBox().getRenderer();
    }

    @Override
    protected ComboPopup createPopup() {
        EPComboPopup popup = new EPComboPopup(this.comboBox);
        popup.setFont(HudPaintingUtils.getHudFont().deriveFont(0));
        popup.setVerticalComponentCenterProvider(this.createComboBoxVerticalCenterProvider());
        return popup;
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        int width = this.getDisplaySize().width;
        int height = this.arrowButton.getPreferredSize().height;
        return new Dimension(width, height);
    }

    @Override
    protected Dimension getDefaultSize() {
        JButton button = HudWidgetFactory.createHudButton("Button");
        return new Dimension(100, button.getPreferredSize().height);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary((Graphics2D)g2, c2);
        super.paint(g2, c2);
        Graphics2D graphics = (Graphics2D)g2.create();
        this.paintUpDownArrowsIcon(graphics);
        graphics.dispose();
    }

    @Override
    public void paintCurrentValue(Graphics g2, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    protected Dimension getDisplaySize() {
        int maxWidth = this.comboBox.getPrototypeDisplayValue() != null ? this.getDisplayWidth(this.comboBox.getPrototypeDisplayValue()) : (this.comboBox.getItemCount() > 0 ? this.getMaxComboBoxModelDisplayWidth() : this.getDefaultSize().width);
        Insets arrowButtonInsets = this.arrowButton.getInsets();
        return new Dimension(maxWidth += arrowButtonInsets.left + arrowButtonInsets.right, this.arrowButton.getPreferredSize().height);
    }

    private int getMaxComboBoxModelDisplayWidth() {
        int maxWidth = 0;
        for (int i2 = 0; i2 < this.comboBox.getModel().getSize(); ++i2) {
            int itemWidth = this.getDisplayWidth(this.comboBox.getModel().getElementAt(i2));
            maxWidth = Math.max(maxWidth, itemWidth);
        }
        return maxWidth;
    }

    private int getDisplayWidth(Object object) {
        assert (object != null) : "The given object cannot be null";
        FontMetrics fontMetrics = this.comboBox.getFontMetrics(this.comboBox.getFont());
        return fontMetrics.stringWidth(object.toString());
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                throw new UnsupportedOperationException("This operation is not supported.");
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                throw new UnsupportedOperationException("This operation is not supported.");
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getPreferredSize().width, ((HudComboBoxUI)HudComboBoxUI.this).arrowButton.getPreferredSize().height);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                int buttonHeight = ((HudComboBoxUI)HudComboBoxUI.this).arrowButton.getPreferredSize().height;
                int y2 = parent.getHeight() / 2 - buttonHeight / 2;
                HudComboBoxUI.this.arrowButton.setBounds(0, y2, parent.getWidth(), buttonHeight);
            }
        };
    }

    private int calculateArrowButtonVisualVerticalCenter() {
        int arrowButtonShadowHeight = HudPaintingUtils.getHudControlShadowSize(this.arrowButton);
        return (this.comboBox.getHeight() - arrowButtonShadowHeight) / 2;
    }

    private void paintUpDownArrowsIcon(Graphics2D graphics) {
        Insets arrowButtonInsets = this.arrowButton.getInsets();
        int arrowButtonHeight = this.arrowButton.getHeight();
        int centerX = this.arrowButton.getWidth() - arrowButtonInsets.right / 2;
        int centerY = this.calculateArrowButtonVisualVerticalCenter();
        int verticalDistanceBetweenArrows = (int)((double)arrowButtonHeight * 0.125);
        int arrowSideLength = verticalDistanceBetweenArrows * 2;
        int upArrowX = centerX - arrowSideLength / 2;
        int upArrowY = centerY - verticalDistanceBetweenArrows / 2;
        graphics.setColor(this.isDarkColorScheme ? WidgetBaseColors.DARK_FONT_COLOR : WidgetBaseColors.LIGHT_FONT_COLOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(upArrowX, upArrowY);
        graphics.fill(HudComboBoxUI.createUpArrow(arrowSideLength));
        graphics.translate(0, verticalDistanceBetweenArrows);
        graphics.fill(HudComboBoxUI.createDownArrow(arrowSideLength));
    }

    private static GeneralPath createUpArrow(int arrowSideLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(arrowSideLength, 0.0f);
        path.lineTo(arrowSideLength / 2, -arrowSideLength);
        path.closePath();
        return path;
    }

    private static GeneralPath createDownArrow(int arrowSideLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(arrowSideLength, 0.0f);
        path.lineTo(arrowSideLength / 2, arrowSideLength);
        path.closePath();
        return path;
    }
}

