/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets.plaf;

import com.jtechdev.macwidgets.MacFontUtils;
import com.jtechdev.macwidgets.WidgetBaseColors;
import com.jtechdev.macwidgets.plaf.HudPaintingUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class HudCheckBoxUI
extends BasicCheckBoxUI {
    private boolean isDarkColorScheme = true;

    public HudCheckBoxUI() {
    }

    public HudCheckBoxUI(boolean isDarkColorScheme) {
        this.isDarkColorScheme = isDarkColorScheme;
    }

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        HudPaintingUtils.initHudComponent(b2, this.isDarkColorScheme);
        b2.setIconTextGap(5);
        this.icon = new CheckIcon(this.isDarkColorScheme);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary((Graphics2D)g2, c2);
        super.paint(g2, c2);
    }

    @Override
    protected void paintText(Graphics g2, JComponent c2, Rectangle textRect, String text) {
        MacFontUtils.enableAntialiasing((Graphics2D)g2);
        AbstractButton button = (AbstractButton)c2;
        FontMetrics fontMetrics = g2.getFontMetrics(button.getFont());
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        g2.setColor(button.getForeground());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fontMetrics.getAscent() + this.getTextShiftOffset());
    }

    private class CheckIcon
    implements Icon {
        private final int CHECK_BOX_SIZE = 12;
        private boolean isDarkColorScheme = true;
        private Color fontColor = WidgetBaseColors.DARK_FONT_COLOR;

        public CheckIcon(boolean isDarkColorScheme) {
            this.isDarkColorScheme = isDarkColorScheme;
            this.fontColor = isDarkColorScheme ? WidgetBaseColors.DARK_FONT_COLOR : WidgetBaseColors.LIGHT_FONT_COLOR;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            AbstractButton button = (AbstractButton)c2;
            Graphics2D graphics = (Graphics2D)g2.create();
            graphics.translate(x2, y2);
            HudPaintingUtils.paintHudControlBackground(graphics, button, 12, 12, HudPaintingUtils.Roundedness.CHECK_BOX, this.isDarkColorScheme);
            this.drawCheckMarkIfNecessary(graphics, button.getModel());
            graphics.dispose();
        }

        private void drawCheckMarkIfNecessary(Graphics2D graphics, ButtonModel model) {
            if (model.isSelected()) {
                this.drawCheckMark(graphics, model);
            }
        }

        private void drawCheckMark(Graphics2D graphics, ButtonModel model) {
            int x1 = 3;
            int y1 = 4;
            int x2 = x1 + 2;
            int y2 = y1 + 3;
            int x3 = 10;
            int y3 = -1;
            Color color = model.isPressed() ? HudPaintingUtils.PRESSED_MARK_COLOR : this.fontColor;
            graphics.setStroke(new BasicStroke(1.65f, 2, 1));
            graphics.setColor(color);
            graphics.drawLine(x1, y1, x2, y2);
            graphics.drawLine(x2, y2, x3, y3);
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }
}

