/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jtechdev.macwidgets.ComponentBottomBar;
import com.jtechdev.macwidgets.SourceList;
import com.jtechdev.macwidgets.plaf.EmphasizedLabelUI;
import com.jtechdev.macwidgets.plaf.ITunesTableUI;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableModel;

public class MacWidgetFactory {
    public static JTable createITunesTable(TableModel tableModel) {
        JTable table = new JTable(tableModel);
        table.setUI(new ITunesTableUI());
        return table;
    }

    public static ComponentBottomBar createComponentStatusBar() {
        return new ComponentBottomBar();
    }

    public static JComponent createSpacer(int width, int height) {
        JLabel label = new JLabel();
        label.setOpaque(false);
        label.setPreferredSize(new Dimension(width, height));
        return label;
    }

    public static JLabel createEmphasizedLabel(String text) {
        return MacWidgetFactory.makeEmphasizedLabel(new JLabel(text));
    }

    public static JLabel makeEmphasizedLabel(JLabel label) {
        label.setUI(new EmphasizedLabelUI());
        return label;
    }

    public static JLabel makeEmphasizedLabel(JLabel label, Color focusedColor, Color unfocusedColor, Color emphasisColor) {
        label.setUI(new EmphasizedLabelUI(focusedColor, unfocusedColor, emphasisColor));
        return label;
    }

    public static JSplitPane createSplitPaneForSourceList(SourceList sourceList, JComponent component) {
        JSplitPane splitPane = new JSplitPane(1, sourceList.getComponent(), component);
        splitPane.setContinuousLayout(true);
        splitPane.setDividerSize(1);
        ((BasicSplitPaneUI)splitPane.getUI()).getDivider().setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, new Color(0xA5A5A5)));
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        return splitPane;
    }

    public static JScrollPane createSourceListScrollPane(JComponent content) {
        return MacWidgetFactory.makeSourceListScrollPane(new JScrollPane(content));
    }

    public static JScrollPane makeSourceListScrollPane(JScrollPane scrollPane) {
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }
}

