/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.math.Function2D;
import java.util.Random;

public class CellularFunction2D
implements Function2D {
    public float distancePower = 2.0f;
    public boolean cells = false;
    public boolean angular = false;
    private float[] coefficients = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    private Random random = new Random();
    private Point[] results = new Point[2];

    public CellularFunction2D() {
        for (int j2 = 0; j2 < this.results.length; ++j2) {
            this.results[j2] = new Point();
        }
    }

    public void setCoefficient(int c2, float v2) {
        this.coefficients[c2] = v2;
    }

    public float getCoefficient(int c2) {
        return this.coefficients[c2];
    }

    private float checkCube(float x2, float y2, int cubeX, int cubeY, Point[] results) {
        this.random.setSeed(571 * cubeX + 23 * cubeY);
        int numPoints = 3 + this.random.nextInt() % 4;
        numPoints = 4;
        block0: for (int i2 = 0; i2 < numPoints; ++i2) {
            float px = this.random.nextFloat();
            float py = this.random.nextFloat();
            float dx = Math.abs(x2 - px);
            float dy = Math.abs(y2 - py);
            float d2 = this.distancePower == 1.0f ? dx + dy : (this.distancePower == 2.0f ? (float)Math.sqrt(dx * dx + dy * dy) : (float)Math.pow(Math.pow(dx, this.distancePower) + Math.pow(dy, this.distancePower), 1.0f / this.distancePower));
            for (int j2 = 0; j2 < results.length; ++j2) {
                Point last;
                if ((double)results[j2].distance == Double.POSITIVE_INFINITY) {
                    last = results[j2];
                    last.distance = d2;
                    last.x = px;
                    last.y = py;
                    results[j2] = last;
                    continue block0;
                }
                if (!(d2 < results[j2].distance)) continue;
                last = results[results.length - 1];
                for (int k2 = results.length - 1; k2 > j2; --k2) {
                    results[k2] = results[k2 - 1];
                }
                last.distance = d2;
                last.x = px;
                last.y = py;
                results[j2] = last;
                continue block0;
            }
        }
        return results[1].distance;
    }

    public float evaluate(float x2, float y2) {
        for (int j2 = 0; j2 < this.results.length; ++j2) {
            this.results[j2].distance = Float.POSITIVE_INFINITY;
        }
        int ix = (int)x2;
        float fx = x2 - (float)ix;
        int iy = (int)y2;
        float fy = y2 - (float)iy;
        float d2 = this.checkCube(fx, fy, ix, iy, this.results);
        if (d2 > fy) {
            d2 = this.checkCube(fx, fy + 1.0f, ix, iy - 1, this.results);
        }
        if (d2 > 1.0f - fy) {
            d2 = this.checkCube(fx, fy - 1.0f, ix, iy + 1, this.results);
        }
        if (d2 > fx) {
            this.checkCube(fx + 1.0f, fy, ix - 1, iy, this.results);
            if (d2 > fy) {
                d2 = this.checkCube(fx + 1.0f, fy + 1.0f, ix - 1, iy - 1, this.results);
            }
            if (d2 > 1.0f - fy) {
                d2 = this.checkCube(fx + 1.0f, fy - 1.0f, ix - 1, iy + 1, this.results);
            }
        }
        if (d2 > 1.0f - fx) {
            d2 = this.checkCube(fx - 1.0f, fy, ix + 1, iy, this.results);
            if (d2 > fy) {
                d2 = this.checkCube(fx - 1.0f, fy + 1.0f, ix + 1, iy - 1, this.results);
            }
            if (d2 > 1.0f - fy) {
                d2 = this.checkCube(fx - 1.0f, fy - 1.0f, ix + 1, iy + 1, this.results);
            }
        }
        float t2 = 0.0f;
        for (int i2 = 0; i2 < 2; ++i2) {
            t2 += this.coefficients[i2] * this.results[i2].distance;
        }
        if (this.angular) {
            t2 = (float)((double)t2 + (Math.atan2(fy - this.results[0].y, fx - this.results[0].x) / (Math.PI * 2) + 0.5));
        }
        return t2;
    }

    class Point {
        int index;
        float x;
        float y;
        float distance;

        Point() {
        }
    }
}

