/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class ShapeFilter
extends WholeImageFilter {
    public static final int LINEAR = 0;
    public static final int CIRCLE_UP = 1;
    public static final int CIRCLE_DOWN = 2;
    public static final int SMOOTH = 3;
    private float factor = 1.0f;
    protected Colormap colormap = new LinearColormap();
    private boolean useAlpha = true;
    private boolean invert = false;
    private boolean merge = false;
    private int type;
    private static final int one = 41;
    private static final int sqrt2 = (int)(41.0 * Math.sqrt(2.0));
    private static final int sqrt5 = (int)(41.0 * Math.sqrt(5.0));

    public void setFactor(float factor) {
        this.factor = factor;
    }

    public float getFactor() {
        return this.factor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseAlpha(boolean useAlpha) {
        this.useAlpha = useAlpha;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public boolean getMerge() {
        return this.merge;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int[] map = new int[width * height];
        this.makeMap(inPixels, map, width, height);
        int max = this.distanceMap(map, width, height);
        this.applyMap(map, inPixels, width, height, max);
        return inPixels;
    }

    public int distanceMap(int[] map, int width, int height) {
        int v2;
        int offset;
        int x2;
        int y2;
        int xmax = width - 3;
        int ymax = height - 3;
        int max = 0;
        for (y2 = 0; y2 < height; ++y2) {
            for (x2 = 0; x2 < width; ++x2) {
                offset = x2 + y2 * width;
                if (map[offset] <= 0 || (v2 = x2 < 2 || x2 > xmax || y2 < 2 || y2 > ymax ? this.setEdgeValue(x2, y2, map, width, offset, xmax, ymax) : this.setValue(map, width, offset)) <= max) continue;
                max = v2;
            }
        }
        for (y2 = height - 1; y2 >= 0; --y2) {
            for (x2 = width - 1; x2 >= 0; --x2) {
                offset = x2 + y2 * width;
                if (map[offset] <= 0 || (v2 = x2 < 2 || x2 > xmax || y2 < 2 || y2 > ymax ? this.setEdgeValue(x2, y2, map, width, offset, xmax, ymax) : this.setValue(map, width, offset)) <= max) continue;
                max = v2;
            }
        }
        return max;
    }

    private void makeMap(int[] pixels, int[] map, int width, int height) {
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int offset = x2 + y2 * width;
                int b2 = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                map[offset] = b2 * 41 / 10;
            }
        }
    }

    private void applyMap(int[] map, int[] pixels, int width, int height, int max) {
        if (max == 0) {
            max = 1;
        }
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int offset = x2 + y2 * width;
                int m2 = map[offset];
                float v2 = 0.0f;
                int sa = 0;
                int sr = 0;
                int sg = 0;
                int sb2 = 0;
                if (m2 == 0) {
                    sb2 = 0;
                    sg = 0;
                    sr = 0;
                    sa = 0;
                    sa = pixels[offset] >> 24 & 0xFF;
                } else {
                    v2 = ImageMath.clamp(this.factor * (float)m2 / (float)max, 0.0f, 1.0f);
                    switch (this.type) {
                        case 1: {
                            v2 = ImageMath.circleUp(v2);
                            break;
                        }
                        case 2: {
                            v2 = ImageMath.circleDown(v2);
                            break;
                        }
                        case 3: {
                            v2 = ImageMath.smoothStep(0.0f, 1.0f, v2);
                        }
                    }
                    if (this.colormap == null) {
                        sg = sb2 = (int)(v2 * 255.0f);
                        sr = sb2;
                    } else {
                        int c2 = this.colormap.getColor(v2);
                        sr = c2 >> 16 & 0xFF;
                        sg = c2 >> 8 & 0xFF;
                        sb2 = c2 & 0xFF;
                    }
                    int n2 = sa = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                    if (this.invert) {
                        sr = 255 - sr;
                        sg = 255 - sg;
                        sb2 = 255 - sb2;
                    }
                }
                if (this.merge) {
                    int transp = 255;
                    int col = pixels[offset];
                    int a2 = (col & 0xFF000000) >> 24;
                    int r2 = (col & 0xFF0000) >> 16;
                    int g2 = (col & 0xFF00) >> 8;
                    int b2 = col & 0xFF;
                    r2 = sr * r2 / transp;
                    g2 = sg * g2 / transp;
                    b2 = sb2 * b2 / transp;
                    if (r2 < 0) {
                        r2 = 0;
                    }
                    if (r2 > 255) {
                        r2 = 255;
                    }
                    if (g2 < 0) {
                        g2 = 0;
                    }
                    if (g2 > 255) {
                        g2 = 255;
                    }
                    if (b2 < 0) {
                        b2 = 0;
                    }
                    if (b2 > 255) {
                        b2 = 255;
                    }
                    pixels[offset] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                    continue;
                }
                pixels[offset] = sa << 24 | sr << 16 | sg << 8 | sb2;
            }
        }
    }

    private int setEdgeValue(int x2, int y2, int[] map, int width, int offset, int xmax, int ymax) {
        int r1 = offset - width - width - 2;
        int r2 = r1 + width;
        int r3 = r2 + width;
        int r4 = r3 + width;
        int r5 = r4 + width;
        if (y2 == 0 || x2 == 0 || y2 == ymax + 2 || x2 == xmax + 2) {
            map[offset] = 41;
            return 41;
        }
        int v2 = map[r3 + 1] + 41;
        v2 = map[r2 + 2] + 41;
        int min = v2;
        if (v2 < min) {
            min = v2;
        }
        if ((v2 = map[r3 + 3] + 41) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 2] + 41) < min) {
            min = v2;
        }
        if ((v2 = map[r2 + 1] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r2 + 3] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 1] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 3] + sqrt2) < min) {
            min = v2;
        }
        if (y2 == 1 || x2 == 1 || y2 == ymax + 1 || x2 == xmax + 1) {
            map[offset] = min;
            return map[offset];
        }
        v2 = map[r1 + 1] + sqrt5;
        if (v2 < min) {
            min = v2;
        }
        if ((v2 = map[r1 + 3] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r2 + 4] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 4] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r5 + 3] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r5 + 1] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r4] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r2] + sqrt5) < min) {
            min = v2;
        }
        map[offset] = min;
        return map[offset];
    }

    private int setValue(int[] map, int width, int offset) {
        int r1 = offset - width - width - 2;
        int r2 = r1 + width;
        int r3 = r2 + width;
        int r4 = r3 + width;
        int r5 = r4 + width;
        int v2 = map[r3 + 1] + 41;
        v2 = map[r2 + 2] + 41;
        int min = v2;
        if (v2 < min) {
            min = v2;
        }
        if ((v2 = map[r3 + 3] + 41) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 2] + 41) < min) {
            min = v2;
        }
        if ((v2 = map[r2 + 1] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r2 + 3] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 1] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 3] + sqrt2) < min) {
            min = v2;
        }
        if ((v2 = map[r1 + 1] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r1 + 3] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r2 + 4] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r4 + 4] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r5 + 3] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r5 + 1] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r4] + sqrt5) < min) {
            min = v2;
        }
        if ((v2 = map[r2] + sqrt5) < min) {
            min = v2;
        }
        map[offset] = min;
        return map[offset];
    }

    public String toString() {
        return "Stylize/Shapeburst...";
    }
}

