/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.extras;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyAccessor;
import com.jgoodies.binding.beans.PropertyAccessors;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import com.jgoodies.common.bean.Bean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

public final class FastPropertyAccessorProviderDraft
implements PropertyAccessors.PropertyAccessorProvider {
    private final Map<Class<?>, CacheEntry> cache = new IdentityHashMap(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyAccessor getAccessor(Class<?> beanClass, String propertyName, String getterName, String setterName) {
        Map<Class<?>, CacheEntry> map = this.cache;
        synchronized (map) {
            CacheEntry e2 = this.cache.get(beanClass);
            if (e2 == null) {
                e2 = new CacheEntry(beanClass);
                this.cache.put(beanClass, e2);
            }
            return e2.getAccessor(propertyName, getterName, setterName);
        }
    }

    private static final class CacheEntry {
        private final Map<String, Object> methods;
        private final Map<String, PropertyAccessor> accessors;

        CacheEntry(Class<?> beanClass) {
            Method[] publicMethods = beanClass.getMethods();
            int size = publicMethods.length;
            this.methods = new IdentityHashMap<String, Object>(size);
            this.accessors = new IdentityHashMap<String, PropertyAccessor>(size / 2);
            for (Method m2 : publicMethods) {
                Class<?> declaringClass = m2.getDeclaringClass();
                if (Modifier.isStatic(m2.getModifiers()) || declaringClass == Model.class || declaringClass == Bean.class || declaringClass == Object.class) continue;
                Class<?>[] ptypes = m2.getParameterTypes();
                Class<?> rtype = m2.getReturnType();
                if (ptypes.length > 0 && rtype != Void.TYPE && rtype != Void.class) continue;
                String name = m2.getName();
                if (name.startsWith("set")) {
                    Map<Class<?>, Method> map;
                    if (ptypes.length == 0 || ptypes.length > 1) continue;
                    Object o2 = this.methods.get(name);
                    if (o2 == null) {
                        this.methods.put(name, m2);
                        continue;
                    }
                    if (o2 instanceof Method) {
                        map = new IdentityHashMap(10);
                        map.put(ptypes[0], m2);
                        Method other = (Method)o2;
                        Class<?>[] otherTypes = other.getParameterTypes();
                        map.put(otherTypes[0], other);
                        this.methods.put(name, map);
                        continue;
                    }
                    if (!(o2 instanceof Map)) continue;
                    map = (Map)o2;
                    map.put(ptypes[0], m2);
                    continue;
                }
                this.methods.put(name, m2);
            }
        }

        PropertyAccessor getAccessor(String propertyName, String getterName, String setterName) {
            Class<?>[] ptypes;
            PropertyAccessor d2 = this.accessors.get(propertyName);
            if (d2 != null) {
                return d2;
            }
            if (setterName != null || getterName != null) {
                Method readMethod = (Method)this.methods.get(getterName);
                Method writeMethod = (Method)this.methods.get(setterName);
                PropertyAccessor pa = new PropertyAccessor(propertyName, readMethod, writeMethod);
                this.accessors.put(propertyName, pa);
                return pa;
            }
            String methodSuffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            String getter0 = ("get" + methodSuffix).intern();
            Method readMethod = (Method)this.methods.get(getter0);
            if (readMethod == null) {
                String getter1 = ("is" + methodSuffix).intern();
                readMethod = (Method)this.methods.get(getter1);
            }
            Class<?> rtype = null;
            if (readMethod != null) {
                rtype = readMethod.getReturnType();
            }
            String setter = ("set" + methodSuffix).intern();
            Object o2 = this.methods.get(setter);
            Method writeMethod = null;
            if (o2 instanceof Method) {
                writeMethod = (Method)o2;
            } else if (o2 instanceof Map) {
                Map map = (Map)o2;
                writeMethod = (Method)map.get(rtype);
            }
            if (readMethod != null && writeMethod != null && (ptypes = writeMethod.getParameterTypes()).length > 0 && ptypes[0] != rtype && rtype != null && !rtype.isAssignableFrom(ptypes[0])) {
                throw new IllegalStateException("Type mismatch between read and write methods.\npropertyName=" + propertyName + "\nread method =" + readMethod + "\nwrite method=" + writeMethod);
            }
            if (readMethod == null && writeMethod == null) {
                throw new PropertyNotFoundException(propertyName, (Object)null);
            }
            d2 = new PropertyAccessor(propertyName, readMethod, writeMethod);
            this.accessors.put(propertyName, d2);
            return d2;
        }
    }
}

