/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public final class RadioButtonAdapter
extends JToggleButton.ToggleButtonModel {
    private final ValueModel subject;
    private final Object choice;

    public RadioButtonAdapter(ValueModel subject, Object choice) {
        this.subject = Preconditions.checkNotNull(subject, "The %1$s must not be null.", "subject");
        this.choice = choice;
        subject.addValueChangeListener(new SubjectValueChangeHandler());
        this.updateSelectedState();
    }

    @Override
    public void setSelected(boolean b2) {
        if (!b2 || this.isSelected()) {
            return;
        }
        this.subject.setValue(this.choice);
        this.updateSelectedState();
    }

    @Override
    public void setGroup(ButtonGroup group) {
        if (group != null) {
            throw new UnsupportedOperationException("You need not and must not use a ButtonGroup with a set of RadioButtonAdapters. These form a group by sharing the same subject ValueModel.");
        }
    }

    private void updateSelectedState() {
        boolean subjectHoldsChoiceValue = Objects.equals(this.choice, this.subject.getValue());
        super.setSelected(subjectHoldsChoiceValue);
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RadioButtonAdapter.this.updateSelectedState();
        }
    }
}

