/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.model.treetable.ColumnModelEvent;
import com.dlsc.flexgantt.model.treetable.ColumnModelIterator;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModelListener;
import com.dlsc.flexgantt.model.treetable.SortDirection;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChartControl;
import com.dlsc.flexgantt.swing.ISortingListener;
import com.dlsc.flexgantt.swing.SortingEvent;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.DefaultColumnHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableHeaderMenuProvider;
import com.dlsc.flexgantt.swing.treetable.IColumnHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.ITreeTableHeaderMenuProvider;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JPopupMenu;

public class TreeTableHeader
extends GanttChartControl
implements PropertyChangeListener,
MouseListener,
MouseMotionListener,
IColumnModelListener,
ISortingListener {
    private static final Logger LOGGER = Logger.getLogger(TreeTableHeader.class.getName());
    private static final Cursor RESIZE_CURSOR = new Cursor(11);
    private static final Cursor MOVE_CURSOR = new Cursor(13);
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private TreeTableColumn fillerColumn = new TreeTableColumn("", Object.class, Integer.MAX_VALUE);
    private TreeTableColumn draggedColumn;
    private CellRendererPane rendererPane = new CellRendererPane();
    private int dragOffset;
    private int dragCurrent;
    private IColumnModel model;
    private boolean showingFillerColumn = true;
    private List<SortEntry> sortEntries = new ArrayList<SortEntry>();
    private TreeTableColumn focusedColumn;
    private Color gridColor = ColorUtil.getGridColor();
    private Map<Class, IColumnHeaderRenderer> rendererMap;
    private Map<Class, IColumnHeaderRenderer> rendererCache;
    private ITreeTableHeaderMenuProvider menuProvider = new DefaultTreeTableHeaderMenuProvider();
    private boolean doubleClickResizeEnabled = true;
    private boolean focusEnabled;

    public TreeTableHeader(AbstractGanttChart gc2) {
        super(gc2);
        this.setName("TreeTableHeader");
        this.setFocusable(false);
        this.add(this.rendererPane);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.rendererMap = new HashMap<Class, IColumnHeaderRenderer>(10);
        this.rendererCache = new HashMap<Class, IColumnHeaderRenderer>(10);
        this.setColumnHeaderRenderer(Object.class, new DefaultColumnHeaderRenderer());
        this.setBorder(new CustomizableLineBorder(true, false, true, false));
        this.setOpaque(true);
        this.setModel(gc2.getColumnModel());
        gc2.addPropertyChangeListener(this);
        gc2.addSortingListener(this);
        Timeline timeline = gc2.getTimeline();
        timeline.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                TreeTableHeader.this.revalidate();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintColumnHeaders(g2);
    }

    protected void paintColumnHeaders(Graphics g2) {
        int x2 = 0;
        AbstractGanttChart ganttChart = this.getGanttChart();
        ColumnModelIterator iter = new ColumnModelIterator(this.model, ganttChart.getKeyColumnPosition());
        while (iter.hasNext()) {
            TreeTableColumn column = iter.next();
            int width = column.getWidth();
            this.paintColumnHeader(g2, column, x2 + 1, 0, width - 2, this.getHeight());
            g2.setColor(this.gridColor);
            g2.drawLine((x2 += width) - 1, 0, x2 - 1, this.getHeight());
        }
        if (this.showingFillerColumn) {
            int width = this.getWidth() - this.model.getTotalColumnWidth();
            this.paintColumnHeader(g2, this.fillerColumn, x2, 0, width, this.getHeight());
        }
    }

    protected void paintColumnHeader(Graphics g2, TreeTableColumn column, int x2, int y2, int width, int height) {
        Object value = column.getHeaderValue();
        if (value == null) {
            value = column.getName();
        }
        IColumnHeaderRenderer renderer = this.getColumnHeaderRenderer(value.getClass());
        SortDirection sortDir = SortDirection.NONE;
        for (SortEntry se : this.sortEntries) {
            if (se.column.getModelIndex() != column.getModelIndex()) continue;
            if (se.ascending) {
                sortDir = SortDirection.ASCENDING;
                break;
            }
            sortDir = SortDirection.DESCENDING;
            break;
        }
        boolean hasFocus = this.focusedColumn == column && this.focusEnabled;
        int sortPosition = this.getSortPosition(column.getModelIndex());
        Component comp = renderer.getColumnHeaderRendererComponent(this, column, false, hasFocus, sortDir, sortPosition);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("g = " + g2 + " column = " + column + " activeColumn = " + this.draggedColumn + " dragCurrent = " + this.dragCurrent + " x = " + x2 + " y = " + y2 + " width = " + width + " height = " + height);
        }
        this.rendererPane.paintComponent(g2, comp, this, x2, y2, width, height, true);
    }

    public int getSortPosition(int modelIndex) {
        for (int i2 = 0; i2 < this.sortEntries.size(); ++i2) {
            SortEntry se = this.sortEntries.get(i2);
            if (se.column.getModelIndex() != modelIndex) continue;
            return i2 + 1;
        }
        return -1;
    }

    public int getSortCount() {
        return this.sortEntries.size();
    }

    public TreeTableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.model.getTotalColumnWidth();
        IColumnHeaderRenderer renderer = null;
        if (this.model.getKeyColumn() != null) {
            Object value = this.model.getKeyColumn().getHeaderValue();
            if (value == null) {
                value = this.model.getKeyColumn().getName();
            }
            renderer = this.getColumnHeaderRenderer(value.getClass());
        }
        int sortPosition = -1;
        if (this.model.getKeyColumn() != null) {
            sortPosition = this.getSortPosition(this.model.getKeyColumn().getModelIndex());
        }
        Component comp = null;
        if (renderer != null) {
            comp = renderer.getColumnHeaderRendererComponent(this, this.model.getKeyColumn(), false, false, SortDirection.NONE, sortPosition);
        }
        int height = 0;
        if (comp != null) {
            height = comp.getPreferredSize().height;
        }
        int count = this.model.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            TreeTableColumn column = this.model.getColumn(i2);
            if (column == null) continue;
            Object value = column.getHeaderValue();
            if (value == null) {
                value = column.getName();
            }
            renderer = this.getColumnHeaderRenderer(value.getClass());
            sortPosition = this.getSortPosition(column.getModelIndex());
            comp = renderer.getColumnHeaderRendererComponent(this, column, false, false, SortDirection.NONE, sortPosition);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        height = Math.max(height, this.getGanttChart().getTimeline().getPreferredSize().height);
        return new Dimension(width, height);
    }

    public int getColumnIndexAt(int x2) {
        if (x2 < 0) {
            throw new IllegalArgumentException("x must be > 0");
        }
        int p2 = 0;
        AbstractGanttChart ganttChart = this.getGanttChart();
        ColumnModelIterator iter = new ColumnModelIterator(this.model, ganttChart.getKeyColumnPosition());
        int counter = 0;
        while (iter.hasNext()) {
            TreeTableColumn column = iter.next();
            int width = column.getWidth();
            if (x2 >= p2 && x2 <= p2 + width) {
                if (column == this.model.getKeyColumn()) {
                    return -1;
                }
                return counter;
            }
            if (!column.equals(this.model.getKeyColumn())) {
                ++counter;
            }
            p2 += width;
        }
        return Integer.MIN_VALUE;
    }

    private void setModel(IColumnModel model) {
        int i2;
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        IColumnModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeColumnModelListener(this);
            TreeTableColumn column = oldModel.getKeyColumn();
            if (column != null) {
                column.removePropertyChangeListener(this);
            }
            int count = oldModel.getColumnCount();
            for (i2 = 0; i2 < count; ++i2) {
                column = oldModel.getColumn(i2);
                column.removePropertyChangeListener(this);
            }
        }
        this.model = model;
        this.model.addColumnModelListener(this);
        int count = model.getColumnCount();
        TreeTableColumn column = model.getKeyColumn();
        column.addPropertyChangeListener(this);
        for (i2 = 0; i2 < count; ++i2) {
            column = model.getColumn(i2);
            column.addPropertyChangeListener(this);
        }
    }

    public IColumnModel getModel() {
        return this.model;
    }

    public void setFocusEnabled(boolean focusEnabled) {
        this.focusEnabled = focusEnabled;
    }

    public boolean isFocusEnabled() {
        return this.focusEnabled;
    }

    @Override
    public void columnModelChanged(ColumnModelEvent evt) {
        TreeTableColumn column = evt.getColumn();
        switch (evt.getId()) {
            case COLUMN_ADDED: {
                column.addPropertyChangeListener(this);
                break;
            }
            case COLUMN_REMOVED: {
                column.removePropertyChangeListener(this);
                break;
            }
            case COLUMN_INSERTED: {
                column.addPropertyChangeListener(this);
                break;
            }
        }
        this.invalidate();
        this.validate();
    }

    private TreeTableColumn checkColumnAt(int x2) {
        int kp = this.getGanttChart().getKeyColumnPosition();
        ColumnModelIterator iter = new ColumnModelIterator(this.model, kp);
        int p2 = 0;
        while (iter.hasNext()) {
            TreeTableColumn column = iter.next();
            int width = column.getWidth();
            if (x2 >= p2 + width - 5 && x2 < p2 + width) {
                return column;
            }
            p2 += width;
        }
        return null;
    }

    public TreeTableColumn getColumn(int index) {
        if (index == -1) {
            return this.model.getKeyColumn();
        }
        int kp = this.getGanttChart().getKeyColumnPosition();
        ColumnModelIterator iter = new ColumnModelIterator(this.model, kp);
        int count = 0;
        while (iter.hasNext()) {
            TreeTableColumn col = iter.next();
            if (col == this.model.getKeyColumn()) continue;
            if (index == count) {
                return col;
            }
            ++count;
        }
        return null;
    }

    public TreeTableColumn getColumnAt(int x2) {
        int index = this.getColumnIndexAt(x2);
        return this.getColumn(index);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        int index;
        if (!this.maybeShowPopup(e2) && e2.getButton() == 1 && (index = this.getColumnIndexAt(e2.getX())) != Integer.MIN_VALUE) {
            TreeTableColumn col = this.model.getKeyColumn();
            if (index != -1) {
                col = this.model.getColumn(index);
            }
            if (e2.getClickCount() == 2 && this.getCursor().equals(RESIZE_CURSOR) && this.doubleClickResizeEnabled) {
                if (e2.isShiftDown()) {
                    this.getGanttChart().optimizeColumnWidth();
                } else {
                    this.getGanttChart().optimizeColumnWidth(index);
                }
                return;
            }
            if (!this.getCursor().equals(DEFAULT_CURSOR)) {
                return;
            }
            boolean keepSortedColumns = (e2.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
            this.sortColumn(col, keepSortedColumns);
        }
    }

    public void sortColumn(TreeTableColumn col, boolean keepSortedColumns) {
        if (col.isSortable()) {
            int i2;
            int modelIndex = col.getModelIndex();
            boolean found = false;
            if (!keepSortedColumns) {
                for (i2 = this.sortEntries.size() - 1; i2 >= 0; --i2) {
                    SortEntry se = this.sortEntries.get(i2);
                    if (se.column.getModelIndex() != modelIndex) {
                        if (!se.column.isSupported(SortDirection.NONE)) continue;
                        this.sortEntries.remove(se);
                        continue;
                    }
                    found = true;
                }
                if (!found) {
                    SortEntry se = new SortEntry();
                    se.column = col;
                    se.ascending = col.isSupported(SortDirection.ASCENDING);
                    this.sortEntries.add(se);
                }
            } else {
                boolean found2 = false;
                for (int i3 = this.sortEntries.size() - 1; i3 >= 0; --i3) {
                    SortEntry se = this.sortEntries.get(i3);
                    if (se.column.getModelIndex() != modelIndex) continue;
                    found2 = true;
                    this.nextState(se);
                }
                if (!found2) {
                    SortEntry se = new SortEntry();
                    se.column = col;
                    se.ascending = col.isSupported(SortDirection.ASCENDING);
                    this.sortEntries.add(se);
                }
            }
            if (found) {
                for (i2 = this.sortEntries.size() - 1; i2 >= 0; --i2) {
                    SortEntry se = this.sortEntries.get(i2);
                    if (se.column.getModelIndex() != modelIndex) continue;
                    this.nextState(se);
                }
            }
            int s2 = this.sortEntries.size();
            final int[] modelIndices = new int[s2];
            final boolean[] ascending = new boolean[s2];
            for (int i4 = 0; i4 < s2; ++i4) {
                SortEntry se = this.sortEntries.get(i4);
                modelIndices[i4] = se.column.getModelIndex();
                ascending[i4] = se.ascending;
            }
            Thread thread = new Thread(){

                @Override
                public void run() {
                    TreeTableHeader.this.getGanttChart().sortTables(modelIndices, ascending);
                }
            };
            thread.setName("FlexGanttSortingThread");
            thread.start();
        }
    }

    private void nextState(SortEntry se) {
        if (se.ascending) {
            if (se.column.isSupported(SortDirection.DESCENDING)) {
                se.ascending = false;
            } else if (se.column.isSupported(SortDirection.NONE)) {
                this.sortEntries.remove(se);
            }
        } else if (se.column.isSupported(SortDirection.NONE)) {
            this.sortEntries.remove(se);
        } else if (se.column.isSupported(SortDirection.ASCENDING)) {
            se.ascending = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.getGanttChart().requestFocus();
        if (!this.maybeShowPopup(e2)) {
            this.draggedColumn = this.checkColumnAt(e2.getX());
            if (this.draggedColumn != null) {
                this.setCursor(RESIZE_CURSOR);
            } else {
                this.setCursor(DEFAULT_CURSOR);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.draggedColumn = null;
        this.maybeShowPopup(e2);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        LOGGER.finest(e2.toString());
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        LOGGER.finest(e2.toString());
        this.focusedColumn = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        Rectangle rect;
        LOGGER.finest(e2.toString());
        if (this.getCursor() == MOVE_CURSOR) {
            this.dragCurrent = e2.getX() - this.dragOffset;
            this.repaint();
        } else if (this.getCursor() == RESIZE_CURSOR && (rect = this.getColumnBounds(this.draggedColumn)) != null) {
            this.dragCurrent = rect.x;
            int newWidth = Math.max(this.draggedColumn.getMinimumWidth(), e2.getX() - rect.x);
            try {
                this.draggedColumn.setWidth(newWidth);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        LOGGER.finest(e2.toString());
        if (this.checkColumnAt(e2.getX()) != null) {
            this.setCursor(RESIZE_CURSOR);
        } else {
            this.setCursor(DEFAULT_CURSOR);
        }
        TreeTableColumn column = null;
        int index = this.getColumnIndexAt(e2.getX());
        if (index != Integer.MIN_VALUE) {
            column = index == -1 ? this.model.getKeyColumn() : this.model.getColumn(index);
        }
        if (column != this.focusedColumn) {
            this.focusedColumn = column;
            this.repaint();
        }
    }

    public int getColumnLocation(TreeTableColumn c2) {
        AbstractGanttChart ganttChart = this.getGanttChart();
        ColumnModelIterator iter = new ColumnModelIterator(this.model, ganttChart.getKeyColumnPosition());
        int x2 = 0;
        while (iter.hasNext()) {
            TreeTableColumn column = iter.next();
            if (column == c2) {
                return x2;
            }
            x2 += column.getWidth();
        }
        if (c2 == this.fillerColumn) {
            return x2;
        }
        throw new IllegalArgumentException("column " + c2.getName() + " is not a member of this model");
    }

    public Rectangle getColumnBounds(TreeTableColumn c2) {
        int x2 = this.getColumnLocation(c2);
        int y2 = 0;
        int width = c2.getWidth();
        int height = this.getHeight();
        return new Rectangle(x2, y2, width, height);
    }

    public Rectangle getColumnBounds(int index) {
        TreeTableColumn col = this.model.getKeyColumn();
        if (index != -1) {
            col = this.model.getColumn(index);
        }
        if (col != null) {
            return this.getColumnBounds(col);
        }
        return null;
    }

    public TreeTableColumn getFillerColumn() {
        return this.fillerColumn;
    }

    public boolean isShowingFillerColumn() {
        return this.showingFillerColumn;
    }

    public void setShowingFillerColumn(boolean show) {
        this.showingFillerColumn = show;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this.getGanttChart())) {
            if (evt.getPropertyName().equals("columnModel")) {
                this.setModel(this.getGanttChart().getColumnModel());
            } else if (evt.getPropertyName().equals("keyColumnPosition")) {
                this.repaint();
            }
        } else if (evt.getSource() instanceof TreeTableColumn) {
            this.repaint();
        }
    }

    public void setColumnHeaderRenderer(Class objectType, IColumnHeaderRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the header value object type can not be NULL");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("the column header renderer can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(objectType, renderer);
    }

    public IColumnHeaderRenderer getColumnHeaderRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IColumnHeaderRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getColumnHeaderRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public ITreeTableHeaderMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void setMenuProvider(ITreeTableHeaderMenuProvider provider) {
        this.menuProvider = provider;
    }

    private boolean maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger() && !evt.isConsumed()) {
            JPopupMenu popup = null;
            if (this.menuProvider != null) {
                TreeTableColumn column = this.getColumnAt(evt.getX());
                popup = this.menuProvider.getPopupMenu(this, evt, column);
            } else {
                popup = this.getComponentPopupMenu();
            }
            if (popup != null) {
                popup.show(this, evt.getX(), evt.getY());
                return true;
            }
        }
        return false;
    }

    public Map<Class, IColumnHeaderRenderer> getRendererMap() {
        return this.rendererMap;
    }

    public void setRendererMap(Map<Class, IColumnHeaderRenderer> map) {
        this.rendererMap = map;
    }

    public boolean isDoubleClickResizeEnabled() {
        return this.doubleClickResizeEnabled;
    }

    public void setDoubleClickResizeEnabled(boolean enabled) {
        this.doubleClickResizeEnabled = enabled;
    }

    @Override
    public void sorting(SortingEvent evt) {
        this.repaint();
    }

    class SortEntry {
        TreeTableColumn column;
        boolean ascending;

        SortEntry() {
        }
    }
}

