/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.model.treetable.SortDirection;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.swing.treetable.IColumnHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;

public class DefaultColumnHeaderRenderer
extends JLabel
implements IColumnHeaderRenderer {
    private static final Logger LOGGER = Logger.getLogger(DefaultColumnHeaderRenderer.class.getName());
    protected Color focusForeground = ColorUtil.getFocusForeground();
    protected Color focusBackground = ColorUtil.getFocusBackground();
    protected SortDirection sortDirection;
    protected Font sortOrderFont = new Font("courier", 0, 8);
    protected int sortPosition;
    protected boolean multiColumnSort;

    public DefaultColumnHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getColumnHeaderRendererComponent(TreeTableHeader header, TreeTableColumn column, boolean selected, boolean hasFocus, SortDirection sortDirection, int sortPosition) {
        Object headerValue;
        this.sortDirection = sortDirection;
        this.sortPosition = sortPosition;
        this.multiColumnSort = header.getSortCount() > 1;
        this.setFont(header.getFont());
        this.setOpaque(hasFocus);
        this.setEnabled(header.isEnabled());
        if (hasFocus) {
            this.setForeground(this.focusForeground);
            this.setBackground(this.focusBackground);
        } else {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            String sortString = "UNKNOWN";
            switch (sortDirection) {
                case NONE: {
                    sortString = "SORTED_NONE";
                    break;
                }
                case ASCENDING: {
                    sortString = "SORTED_ASCENDING";
                    break;
                }
                case DESCENDING: {
                    sortString = "SORTED_DESCENDING";
                }
            }
            LOGGER.log(Level.FINER, "column = " + column + " selected = " + selected + " focus = " + hasFocus + " sortDirection = " + sortString);
        }
        if ((headerValue = column.getHeaderValue()) != null) {
            if (headerValue instanceof Icon) {
                this.setIcon((Icon)headerValue);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(headerValue.toString());
            }
        } else {
            this.setIcon(null);
            this.setText(column.getName());
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getForeground());
        int w2 = this.getWidth() - 10;
        int h2 = this.getHeight();
        int my = h2 / 2;
        switch (this.sortDirection) {
            case ASCENDING: {
                int[] xx2 = new int[]{w2 - 4, w2 + 4, w2};
                int[] yy2 = new int[]{my + 4, my + 4, my - 4};
                g2d.fillPolygon(xx2, yy2, 3);
                break;
            }
            case DESCENDING: {
                int[] xx1 = new int[]{w2 - 4, w2 + 4, w2};
                int[] yy1 = new int[]{my - 4, my - 4, my + 4};
                g2d.fillPolygon(xx1, yy1, 3);
                break;
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        if (this.multiColumnSort && !this.sortDirection.equals((Object)SortDirection.NONE)) {
            g2d.setFont(this.sortOrderFont);
            FontMetrics fm = g2d.getFontMetrics();
            int ascent = fm.getAscent();
            String str = Integer.toString(this.sortPosition);
            int strWidth = fm.stringWidth(str);
            g2d.drawString(str, w2 - strWidth / 2, my + 6 + ascent);
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width += 32;
        return dim;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color color) {
        this.focusBackground = color;
    }

    public Color getFocusForeground() {
        return this.focusForeground;
    }

    public void setFocusForeground(Color color) {
        this.focusForeground = color;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

