/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.ColumnChooser;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.util.WindowsCornerIcon;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ColumnChooserSelector
extends Selector
implements MouseListener,
MouseMotionListener {
    private ColumnChooser chooser;
    private Point dragStart;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel contentPanel = new JPanel();
    private JLabel resizeIconLabel;

    public ColumnChooserSelector(JComponent parentComponent, AbstractGanttChart gc2) {
        super(Messages.getString("ColumnChooserSelector.TITLE"), parentComponent, Selector.Location.BELOW);
        this.contentPanel.setLayout(new BorderLayout());
        this.chooser = new ColumnChooser(gc2);
        this.contentPanel.add("Center", this.chooser);
        this.contentPanel.setOpaque(false);
        this.chooser.setOpaque(false);
        JPanel footerPanel = this.getFooterPanel();
        footerPanel.removeAll();
        footerPanel.setOpaque(false);
        footerPanel.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        footerPanel.add("Center", this.buttonPanel);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonPanel.setOpaque(false);
        this.closeButton = new JButton(Messages.getString("ColumnChooserSelector.CLOSE_BUTTON"));
        this.closeButton.setOpaque(false);
        this.closeButton.setToolTipText(Messages.getString("ColumnChooserSelector.CLOSE_TOOLTIP"));
        this.buttonPanel.add(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ColumnChooserSelector.this.setVisible(false);
            }
        });
        this.resizeIconLabel = new JLabel(new WindowsCornerIcon());
        this.resizeIconLabel.setVerticalAlignment(3);
        this.resizeIconLabel.addMouseListener(this);
        this.resizeIconLabel.addMouseMotionListener(this);
        footerPanel.add("East", this.resizeIconLabel);
        footerPanel.setBorder(new EmptyBorder(2, 2, 0, 0));
        this.setContentComponent(this.contentPanel);
    }

    @Override
    public void setVisible(boolean b2) {
        if (b2) {
            this.chooser.updateLists();
        }
        super.setVisible(b2);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.dragStart = e2.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        Point p2 = e2.getPoint();
        int w2 = this.getWidth() + (p2.x - this.dragStart.x);
        int h2 = this.getHeight() + (p2.y - this.dragStart.y);
        JPanel panel = (JPanel)this.getContentPane();
        Insets insets = panel.getBorder().getBorderInsets(panel);
        JPanel footerPanel = this.getFooterPanel();
        JLabel titleLabel = this.getTitleLabel();
        Dimension ps = titleLabel.getPreferredSize();
        this.chooser.setPreferredSize(new Dimension(w2 - insets.left - insets.right, h2 - footerPanel.getHeight() - ps.height - insets.top - insets.bottom - 4));
        this.setBounds(this.getLocation().x, this.getLocation().y, w2, h2);
        this.doLayout();
        this.invalidate();
        this.validateTree();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    public ColumnChooser getColumnChooser() {
        return this.chooser;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public JLabel getResizeIconLabel() {
        return this.resizeIconLabel;
    }
}

