/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.scheduling;

import com.dlsc.flexgantt.model.scheduling.ConstraintViolationMessage;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.model.scheduling.IModelValidator;
import com.dlsc.flexgantt.model.scheduling.IResolution;
import com.dlsc.flexgantt.model.scheduling.IResolutionProvider;
import com.dlsc.flexgantt.model.scheduling.Violation;
import com.dlsc.flexgantt.swing.MessageTableModel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class ResolutionTableCellEditor
extends DefaultCellEditor
implements ActionListener {
    private LayerContainer lc;

    public ResolutionTableCellEditor(LayerContainer lc2) {
        super(new JComboBox());
        this.lc = lc2;
        JComboBox box = (JComboBox)this.getComponent();
        box.addActionListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        super.getTableCellEditorComponent(table, value, isSelected, row, column);
        JComboBox box = (JComboBox)this.getComponent();
        MessageTableModel messageModel = (MessageTableModel)table.getModel();
        ConstraintViolationMessage msg = (ConstraintViolationMessage)messageModel.getMessageInRow(row);
        IConstraint constraint = msg.getConstraint();
        Violation violation = msg.getViolation();
        IModelValidator modelValidator = msg.getModelValidator();
        IResolutionProvider rp = this.lc.getResolutionProvider();
        List<IResolution> resolutions = rp.getResolutions(constraint, violation);
        DefaultComboBoxModel<BoxEntry> boxModel = new DefaultComboBoxModel<BoxEntry>();
        for (IResolution res : resolutions) {
            BoxEntry entry = new BoxEntry();
            entry.constraint = constraint;
            entry.violation = violation;
            entry.resolution = res;
            entry.modelValidator = modelValidator;
            boxModel.addElement(entry);
        }
        box.setModel(boxModel);
        return box;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JComboBox box = (JComboBox)this.getComponent();
        BoxEntry entry = (BoxEntry)box.getSelectedItem();
        entry.resolution.resolve(this.lc, entry.constraint, entry.violation, entry.modelValidator);
    }

    class BoxEntry {
        public IModelValidator modelValidator;
        public IConstraint constraint;
        public Violation violation;
        public IResolution<?> resolution;

        BoxEntry() {
        }

        public String toString() {
            return this.resolution.toString();
        }
    }
}

