/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.print;

import com.dlsc.flexgantt.swing.print.IPrintManager;
import com.dlsc.flexgantt.swing.print.PreviewDialog;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintGanttChart;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractPrintManager
implements IPrintManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractPrintManager.class.getName());
    private PreviewDialog previewDialog;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private PrintContext printContext;
    private PrintGanttChart printGanttChart;
    private boolean initialized;

    @Override
    public void print(JComponent parentComponent, PrintContext printContext, boolean preview) {
        this.printContext = printContext;
        this.printContext.validate();
        if (!this.initialized) {
            this.printGanttChart = printContext.createPrintableGanttChart();
            this.printGanttChart.setPreviewDialog(this.previewDialog);
            this.printerJob = PrinterJob.getPrinterJob();
            this.printerJob.setJobName("Gantt Chart");
            this.pageFormat = this.printerJob.defaultPage();
            this.pageFormat.setOrientation(0);
            this.initialized = true;
        }
        this.printGanttChart.copySettings(printContext);
        this.printGanttChart.updateState();
        boolean cancelled = false;
        if (preview) {
            if (this.previewDialog == null) {
                this.previewDialog = this.createPreviewDialog(parentComponent);
            }
            this.printGanttChart.setPreviewDialog(this.previewDialog);
            this.previewDialog.setVisible(true);
            cancelled = this.previewDialog.isCancelled();
        } else {
            boolean bl = cancelled = !this.printerJob.printDialog();
        }
        if (!cancelled) {
            this.printerJob.setPrintable(this.printGanttChart, this.pageFormat);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        AbstractPrintManager.this.printerJob.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                        LOGGER.throwing(this.getClass().getName(), "print()", ex);
                    }
                }
            };
            thread.setName("FlexGanttPrintThread");
            thread.setDaemon(true);
            thread.start();
        } else {
            LOGGER.fine("print job was cancelled");
        }
    }

    protected PreviewDialog createPreviewDialog(JComponent parentComponent) {
        Window window = SwingUtilities.getWindowAncestor(parentComponent);
        if (window instanceof Frame) {
            return new PreviewDialog((Frame)window, (IPrintManager)this);
        }
        if (window instanceof Dialog) {
            return new PreviewDialog((Dialog)window, (IPrintManager)this);
        }
        throw new IllegalStateException("unable to create preview dialog, window ancestor is not an instance of Frame or Dialog");
    }

    @Override
    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    @Override
    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    @Override
    public PrintContext getPrintContext() {
        return this.printContext;
    }

    @Override
    public void setPageFormat(PageFormat format) {
        this.pageFormat = format;
    }

    @Override
    public PrintGanttChart getPrintGanttChart() {
        return this.printGanttChart;
    }
}

