/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import com.dlsc.flexgantt.swing.layer.DefaultLayerFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.TimeNowLayer;
import java.awt.Color;
import java.awt.Graphics;

public class MacLayerFactory
extends DefaultLayerFactory {
    private static final MacLayerFactory instance = new MacLayerFactory();

    public static MacLayerFactory getInstance() {
        return instance;
    }

    @Override
    public <T extends AbstractSystemLayer> T createSystemLayer(LayerContainer lc2, Class<T> layerType) {
        if (layerType == TimeNowLayer.class) {
            return (T)new MyTimeNowLayer(lc2);
        }
        return super.createSystemLayer(lc2, layerType);
    }

    class MyTimeNowLayer
    extends TimeNowLayer {
        public MyTimeNowLayer(LayerContainer lc2) {
            super(lc2);
        }

        @Override
        protected void paintTimeNow(Graphics g2, int x2) {
            Color c2 = new Color(255, 100, 100);
            g2.setColor(c2);
            g2.drawLine(x2 - 1, 0, x2 - 1, this.getHeight());
            g2.setColor(c2.darker());
            g2.drawLine(x2, 0, x2, this.getHeight());
            g2.setColor(c2);
            g2.drawLine(x2 + 1, 0, x2 + 1, this.getHeight());
        }
    }
}

