/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class EmphasizedLabelUI
extends BasicLabelUI {
    private Color fShadowColor;
    private Color fFocusedTextColor;
    private Color fUnfocusedTextColor;
    private static final Color DEFAULT_EMPHASIS_COLOR = new Color(255, 255, 255, 110);
    private static final Color DEFAULT_FOCUSED_FONT_COLOR = new Color(0);
    private static final Color DEFAULT_UNFOCUSED_FONT_COLOR = new Color(0x3F3F3F);
    private static final Color DEFAULT_DISABLED_FONT_COLOR = new Color(0x3F3F3F);

    public EmphasizedLabelUI() {
        this(DEFAULT_FOCUSED_FONT_COLOR, DEFAULT_UNFOCUSED_FONT_COLOR, DEFAULT_EMPHASIS_COLOR);
    }

    public EmphasizedLabelUI(Color focusedTextColor, Color unfocusedTextColor, Color emphasisColor) {
        this.fFocusedTextColor = focusedTextColor;
        this.fUnfocusedTextColor = unfocusedTextColor;
        this.fShadowColor = emphasisColor;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
    }

    @Override
    protected void paintEnabledText(JLabel label, Graphics g2, String s2, int textX, int textY) {
        g2.setColor(this.fShadowColor);
        g2.setFont(label.getFont());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, s2, -1, textX, textY + 1);
        g2.setColor(this.isParentWindowFocused(label) ? this.fFocusedTextColor : this.fUnfocusedTextColor);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, s2, -1, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel label, Graphics g2, String s2, int textX, int textY) {
        g2.setColor(this.fShadowColor.brighter());
        g2.setFont(label.getFont());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, s2, -1, textX, textY + 1);
        g2.setColor(DEFAULT_DISABLED_FONT_COLOR);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, s2, -1, textX, textY);
    }

    private boolean isParentWindowFocused(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null && window.isFocused();
    }
}

