/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionListener;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectSelectionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class DefaultTimelineObjectSelectionModel
implements ITimelineObjectSelectionModel {
    private static final Logger LOGGER = Logger.getLogger(DefaultTimelineObjectSelectionModel.class.getName());
    private ILayer layer;
    private EventListenerList listenerList = new EventListenerList();
    private Map<TreePath, List<TimelineObjectPath>> selectionMap = new HashMap<TreePath, List<TimelineObjectPath>>();

    public DefaultTimelineObjectSelectionModel(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        this.layer = layer;
        LOGGER.fine("created new selection mode (layer = " + layer.getName() + ")");
    }

    public ILayer getLayer() {
        return this.layer;
    }

    @Override
    public void clearSelection() {
        LOGGER.fine("clearing all object selections for all nodes");
        for (TreePath node : this.selectionMap.keySet()) {
            this.clearSelection(node);
        }
    }

    @Override
    public void clearSelection(TreePath node) {
        LOGGER.fine("clearing object selections for node = " + node);
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        List<TimelineObjectPath> oldSelection = this.selectionMap.get(node);
        this.selectionMap.put(node, null);
        if (oldSelection != null && oldSelection.size() > 0) {
            this.fireValueChanged(TimelineObjectSelectionEvent.ID.TIMELINE_OBJECTS_REMOVED, oldSelection);
        }
    }

    @Override
    public void addSelection(TimelineObjectPath path) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adding selected path  = " + path);
        }
        if (path == null) {
            throw new IllegalArgumentException("timeline object path can not be NULL");
        }
        ArrayList<TimelineObjectPath> coll = new ArrayList<TimelineObjectPath>(1);
        coll.add(path);
        this.addSelection(coll);
    }

    @Override
    public void addSelection(Collection<TimelineObjectPath> paths) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adding to selection  = " + paths);
        }
        if (paths == null) {
            throw new IllegalArgumentException("timeline object paths can not be NULL");
        }
        for (TimelineObjectPath path : paths) {
            TreePath node = new TreePath(path.getPath());
            List<TimelineObjectPath> list = this.selectionMap.get(node);
            if (list == null) {
                list = new ArrayList<TimelineObjectPath>();
                this.selectionMap.put(node, list);
            }
            if (list.contains(path)) continue;
            list.add(path);
        }
        this.fireValueChanged(TimelineObjectSelectionEvent.ID.TIMELINE_OBJECTS_ADDED, paths);
    }

    @Override
    public void removeSelection(TimelineObjectPath path) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("removing path  = " + path);
        }
        if (path == null) {
            throw new IllegalArgumentException("timeline object path can not be NULL");
        }
        ArrayList<TimelineObjectPath> coll = new ArrayList<TimelineObjectPath>(1);
        coll.add(path);
        this.removeSelection(coll);
    }

    @Override
    public void removeSelection(Collection<TimelineObjectPath> paths) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("removing from selection  = " + paths);
        }
        if (paths == null) {
            throw new IllegalArgumentException("timeline object paths can not be NULL");
        }
        for (TimelineObjectPath path : paths) {
            TreePath node = new TreePath(path.getPath());
            List<TimelineObjectPath> list = this.selectionMap.get(node);
            if (list != null) {
                list.remove(path);
                if (list.size() == 0) {
                    this.selectionMap.remove(node);
                }
            }
            this.fireValueChanged(TimelineObjectSelectionEvent.ID.TIMELINE_OBJECTS_REMOVED, paths);
        }
    }

    @Override
    public Iterator<TimelineObjectPath> getSelection(TreePath path, ITimeSpan span) {
        List list = this.selectionMap.get(path);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list.iterator();
    }

    @Override
    public Iterator<TimelineObjectPath> getSelection(TreePath node) {
        List<TimelineObjectPath> list = this.selectionMap.get(node);
        if (list != null) {
            return list.iterator();
        }
        List empty = Collections.emptyList();
        return empty.iterator();
    }

    @Override
    public Iterator<TimelineObjectPath> getSelection() {
        ArrayList<TimelineObjectPath> result = new ArrayList<TimelineObjectPath>();
        for (TreePath node : this.selectionMap.keySet()) {
            List<TimelineObjectPath> list = this.selectionMap.get(node);
            if (list == null) continue;
            result.addAll(list);
        }
        return result.iterator();
    }

    @Override
    public boolean isSelected(TimelineObjectPath path) {
        TreePath node = new TreePath(path.getPath());
        List<TimelineObjectPath> list = this.selectionMap.get(node);
        return list != null && list.contains(path);
    }

    @Override
    public Iterator<TreePath> getSelectionPaths() {
        return this.selectionMap.keySet().iterator();
    }

    @Override
    public void addTimelineObjectSelectionModelListener(ITimelineObjectSelectionListener l2) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ITimelineObjectSelectionListener.class, l2);
    }

    @Override
    public void removeTimelineObjectSelectionModelListener(ITimelineObjectSelectionListener l2) {
        if (this.listenerList != null) {
            this.listenerList.remove(ITimelineObjectSelectionListener.class, l2);
        }
    }

    protected void fireValueChanged(TimelineObjectSelectionEvent.ID id2, Collection<TimelineObjectPath> paths) {
        Object[] listeners = this.listenerList.getListenerList();
        TimelineObjectSelectionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ITimelineObjectSelectionListener.class) continue;
            if (e2 == null) {
                ArrayList<TimelineObjectPath> list = new ArrayList<TimelineObjectPath>();
                list.addAll(paths);
                e2 = new TimelineObjectSelectionEvent(this, id2, list);
            }
            ((ITimelineObjectSelectionListener)listeners[i2 + 1]).valueChanged(e2);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.selectionMap.keySet().isEmpty();
    }
}

