/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.ILabelPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.util.LabelType;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;

public class LabelLayer
extends AbstractSystemLayer {
    private int labelGap = 20;

    public LabelLayer(LayerContainer lc2) {
        super("Labels", lc2);
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        Graphics2D g2d = (Graphics2D)g2;
        int startNode = this.layerContainer.getStartRow();
        if (startNode != -1) {
            g2d.setColor(this.layerContainer.getForeground());
            int ascent = g2d.getFontMetrics().getAscent();
            for (ILayer layer : this.layerContainer.getVisibleLayers()) {
                if (!layer.isFeatureEnabled(ILayer.Feature.TIMELINE_OBJECT_DESCRIPTIONS)) continue;
                this.paintLabels(g2d, layer, startNode, ascent);
            }
        }
    }

    private void paintLabels(Graphics2D g2d, ILayer layer, int startNode, int ascent) {
        LayerContainer lc2 = this.getLayerContainer();
        TreeTable table = lc2.getTreeTable();
        List<TreeTableNode> treeTableNodes = table.getTreeTableNodes();
        if (treeTableNodes != null) {
            Rectangle clip = this.layerContainer.getVisibleRect();
            ITimeSpan span = this.getDateline().getTimeSpan();
            long duration = span.getDuration();
            TimeSpan visibleSpan = new TimeSpan(Math.max(0L, span.getStartTime() - duration / 4L), span.getEndTime() + duration / 4L);
            if (startNode < treeTableNodes.size()) {
                TimelineObjectLayer layerUI = this.layerContainer.getTimelineObjectLayer(layer);
                Composite comp = g2d.getComposite();
                float alpha = layerUI.getAlpha();
                g2d.setComposite(AlphaComposite.getInstance(3, alpha));
                IGanttChartModel model = lc2.getModel();
                IPolicyProvider policyProvider = this.getLayerPolicyProvider();
                ILabelPolicy labelPolicy = policyProvider.getPolicy(ILabelPolicy.class);
                int y2 = treeTableNodes.get(startNode).getY();
                int clipLine = 0;
                for (int i2 = startNode; i2 < treeTableNodes.size(); ++i2) {
                    TreeTableNode node = treeTableNodes.get(i2);
                    Object modelNode = node.getModelNode();
                    int rowHeight = node.getHeight();
                    Iterator iter = model.getTimelineObjectsIterator(modelNode, layer, visibleSpan);
                    g2d.clipRect(0, Math.max(clipLine, y2), this.getWidth(), this.getHeight());
                    while (iter.hasNext()) {
                        String desc;
                        Object timelineObject = iter.next();
                        TreePath treePath = node.getPath();
                        TimelineObjectPath path = new TimelineObjectPath(treePath, timelineObject, layer);
                        ObjectBounds bounds = this.layerContainer.getObjectBounds(path);
                        if (!labelPolicy.isLabelTypeVisible(path, model, LabelType.DESCRIPTION) || (desc = labelPolicy.getLabel(path, model, LabelType.DESCRIPTION)) == null) continue;
                        int xx = bounds.x + bounds.width + this.labelGap;
                        int yy = bounds.y + bounds.height / 2 + ascent / 2 - 2;
                        g2d.drawString(desc, xx, yy);
                    }
                    g2d.setClip(clip);
                    if ((y2 += rowHeight) > clip.y + clip.height) break;
                    if (node != table.getAnimationNode()) continue;
                    clipLine = y2;
                    y2 -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
                }
                g2d.setComposite(comp);
            }
        }
    }

    public int getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(int gap) {
        this.labelGap = gap;
    }
}

