/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectEditor;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectEditorListener;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class EditingLayer
extends AbstractSystemLayer
implements MouseListener,
ITimelineObjectEditorListener {
    private ITimelineObjectEditor editor;
    private EditorRemover editorRemover;
    private Component editorComp;
    private TimelineObjectPath editedTimelineObject;

    public EditingLayer(LayerContainer lc2) {
        super("EditingLayer", lc2);
        lc2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                ITimelineObjectEditor editor;
                if (EditingLayer.this.isEditing() && (editor = EditingLayer.this.getTimelineObjectEditor()) != null) {
                    editor.cancelEditing();
                }
            }
        });
        lc2.addMouseListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        IPolicyProvider pp;
        IEditTimelineObjectPolicy ep;
        ObjectBounds bounds;
        TreeTable table;
        int row;
        if (!e2.isConsumed() && e2.getClickCount() == 2 && e2.getButton() == 1 && (row = (table = this.getTreeTable()).getRowAt(e2.getY())) != -1 && (bounds = this.layerContainer.getObjectBoundsAt(e2.getX(), e2.getY())) != null && (ep = (pp = this.getLayerPolicyProvider()).getPolicy(IEditTimelineObjectPolicy.class)).isInPlaceEditable(bounds.getPath(), this.getModel())) {
            this.editObjectAt(bounds.getPath(), e2.getX(), e2.getY());
            this.layerContainer.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        ITimelineObjectEditor editor = this.getTimelineObjectEditor();
        if (editor != null) {
            editor.removeTimelineObjectEditorListener(this);
            if (this.editorComp != null) {
                this.layerContainer.remove(this.editorComp);
            }
            this.setTimelineObjectEditor(null);
            this.editorComp = null;
            this.repaint();
        }
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public ITimelineObjectEditor getTimelineObjectEditor() {
        return this.editor;
    }

    private void setTimelineObjectEditor(ITimelineObjectEditor editor) {
        this.editor = editor;
    }

    public TimelineObjectPath getEditedTimelineObject() {
        return this.editedTimelineObject;
    }

    private Component prepareEditor(ITimelineObjectEditor editor, TimelineObjectPath path) {
        JComponent jComp;
        Component comp = editor.getTimelineObjectEditorComponent(this, path);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent(this.layerContainer);
        }
        return comp;
    }

    private boolean editObjectAt(TimelineObjectPath path, int x2, int y2) {
        Class<?> cl;
        ITimelineObjectEditor editor;
        if (this.editor != null && !this.editor.stopEditing()) {
            return false;
        }
        if (path == null) {
            return false;
        }
        this.editedTimelineObject = path;
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new EditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((editor = this.layerContainer.getTimelineObjectEditor(cl = this.editedTimelineObject.getTimelineObject().getClass())) != null) {
            this.editorComp = this.prepareEditor(editor, path);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.layerContainer.add(this.editorComp);
            Dimension dim = this.editorComp.getPreferredSize();
            this.editorComp.setBounds(Math.min(x2, this.layerContainer.getWidth() - dim.width), Math.min(y2, this.layerContainer.getHeight() - dim.height), dim.width, dim.height);
            this.editorComp.invalidate();
            this.editorComp.validate();
            this.setTimelineObjectEditor(editor);
            editor.addTimelineObjectEditorListener(this);
            this.editorComp.requestFocusInWindow();
            this.layerContainer.scrollRectToVisible(this.editorComp.getBounds());
            return true;
        }
        return false;
    }

    @Override
    public void editingStopped(ChangeEvent e2) {
        ITimelineObjectEditor editor = this.getTimelineObjectEditor();
        if (editor != null) {
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e2) {
        this.removeEditor();
    }

    class EditorRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager focusManager;

        public EditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!EditingLayer.this.isEditing() || EditingLayer.this.layerContainer.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component c2 = this.focusManager.getPermanentFocusOwner(); c2 != null; c2 = c2.getParent()) {
                if (c2 == EditingLayer.this.layerContainer) {
                    return;
                }
                if (!(c2 instanceof Window) && (!(c2 instanceof Applet) || c2.getParent() != null)) continue;
                if (c2 != SwingUtilities.getRoot(EditingLayer.this.layerContainer) || EditingLayer.this.getTimelineObjectEditor().stopEditing()) break;
                EditingLayer.this.getTimelineObjectEditor().cancelEditing();
                break;
            }
        }
    }
}

