/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipRenderer;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.util.PathCalculator;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;

public class DefaultRelationshipRenderer
implements IRelationshipRenderer {
    private PathCalculator calculator = new PathCalculator();
    private BasicStroke lineStroke;
    private BasicStroke selectedLineStroke;
    private BasicStroke focusedLineStroke;
    private Paint linePaint;
    private Paint focusedLinePaint;
    private Paint selectedLinePaint;
    private int arrowSize = 4;
    private IGanttChartModel model;
    private boolean selected;
    private boolean focused;
    private IRelationship relationship;

    public DefaultRelationshipRenderer(PathCalculator calculator) {
        if (calculator == null) {
            throw new IllegalArgumentException("calculator can not be NULL");
        }
        this.calculator = calculator;
        this.lineStroke = new BasicStroke(1.0f);
        this.selectedLineStroke = new BasicStroke(2.0f);
        this.focusedLineStroke = new BasicStroke(4.0f);
        this.linePaint = Color.DARK_GRAY;
        this.focusedLinePaint = Color.ORANGE.brighter();
        this.selectedLinePaint = Color.RED;
    }

    public DefaultRelationshipRenderer() {
        this(new PathCalculator());
    }

    @Override
    public GeneralPath drawRelationship(RelationshipLayer layer, Graphics g2, IRelationship relationship, boolean focused, boolean selected) {
        Graphics2D g2d = (Graphics2D)g2;
        this.selected = selected;
        this.focused = focused;
        this.relationship = relationship;
        this.model = layer.getModel();
        GeneralPath path = new GeneralPath();
        TimelineObjectPath sourcePath = relationship.getSourcePath();
        TimelineObjectPath targetPath = relationship.getTargetPath();
        TreeTable table = layer.getTreeTable();
        int sourceRow = table.getRowForPath(sourcePath);
        int targetRow = table.getRowForPath(targetPath);
        int rowCount = table.getRowCount();
        if (sourceRow != -1 && targetRow != -1 && sourceRow < rowCount && targetRow < rowCount) {
            ILayer sourceLayer = sourcePath.getLayer();
            LayerContainer layerContainer = layer.getLayerContainer();
            TimelineObjectLayer sourceLayerUI = layerContainer.getTimelineObjectLayer(sourceLayer);
            ILayer targetLayer = targetPath.getLayer();
            TimelineObjectLayer targetLayerUI = layerContainer.getTimelineObjectLayer(targetLayer);
            ObjectBounds sourceRect = sourceLayerUI.getObjectBounds(sourcePath);
            ObjectBounds targetRect = targetLayerUI.getObjectBounds(targetPath);
            switch (relationship.getType()) {
                case END_TO_START: {
                    path = this.calculator.calculatePathEndToStart(sourceRect, targetRect);
                    break;
                }
                case START_TO_END: {
                    path = this.calculator.calculatePathStartToEnd(sourceRect, targetRect);
                    break;
                }
                case START_TO_START: {
                    path = this.calculator.calculatePathStartToStart(sourceRect, targetRect);
                    break;
                }
                case END_TO_END: {
                    path = this.calculator.calculatePathEndToEnd(sourceRect, targetRect);
                }
            }
            int tx = (int)path.getCurrentPoint().getX();
            int ty = (int)path.getCurrentPoint().getY();
            g2d.setColor(Color.BLACK);
            float alpha = Math.min(sourceLayerUI.getAlpha(), targetLayerUI.getAlpha());
            if (alpha < 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            if (focused) {
                g2d.setStroke(this.getFocusedLineStroke());
                g2d.setPaint(this.getFocusedLinePaint());
                this.paintRelationshipPath(g2d, relationship, path);
                this.paintArrowHead(g2d, relationship, tx, ty);
            }
            if (selected) {
                g2d.setStroke(this.getSelectedLineStroke());
                g2d.setPaint(this.getSelectedLinePaint());
            } else {
                g2d.setStroke(this.getLineStroke());
                g2d.setPaint(this.getLinePaint());
            }
            this.paintRelationshipPath(g2d, relationship, path);
            this.paintArrowHead(g2d, relationship, tx, ty);
        }
        return path;
    }

    protected void paintRelationshipPath(Graphics g2, IRelationship rel, GeneralPath path) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.draw(path);
    }

    protected void paintArrowHead(Graphics g2, IRelationship rel, int x2, int y2) {
        switch (this.calculator.getArrowDirection()) {
            case RIGHT: {
                for (int i2 = 0; i2 < this.arrowSize; ++i2) {
                    g2.drawLine(x2 - i2, y2 - i2, x2 - i2, y2 + i2);
                }
                break;
            }
            case LEFT: {
                for (int i3 = 0; i3 < this.arrowSize; ++i3) {
                    g2.drawLine(x2 + i3, y2 - i3, x2 + i3, y2 + i3);
                }
                break;
            }
        }
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("paint object can not be null");
        }
        this.linePaint = paint;
    }

    public BasicStroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(BasicStroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke object can not be null");
        }
        this.lineStroke = stroke;
    }

    public Paint getSelectedLinePaint() {
        return this.selectedLinePaint;
    }

    public void setSelectedLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("paint object can not be null");
        }
        this.selectedLinePaint = paint;
    }

    public Paint getFocusedLinePaint() {
        return this.focusedLinePaint;
    }

    public void setFocusedLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("paint object can not be null");
        }
        this.focusedLinePaint = paint;
    }

    public BasicStroke getFocusedLineStroke() {
        return this.focusedLineStroke;
    }

    public void setFocusedLineStroke(BasicStroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke can not be NULL");
        }
        this.focusedLineStroke = stroke;
    }

    public BasicStroke getSelectedLineStroke() {
        return this.selectedLineStroke;
    }

    public void setSelectedLineStroke(BasicStroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("stroke can not be NULL");
        }
        this.selectedLineStroke = stroke;
    }

    public int getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(int arrowSize) {
        if (arrowSize < 0) {
            throw new IllegalArgumentException("arrow size can not be negative but was " + arrowSize);
        }
        this.arrowSize = arrowSize;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected boolean isFocused() {
        return this.focused;
    }

    protected IGanttChartModel getModel() {
        return this.model;
    }

    public IRelationship getRelationship() {
        return this.relationship;
    }
}

