/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.swing.layer.AbstractCustomLayer;
import com.dlsc.flexgantt.swing.layer.ILayerFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Graphics;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;

public class DefaultLayerFactory
implements ILayerFactory {
    private static final Logger LOGGER = Logger.getLogger(DefaultLayerFactory.class.getName());
    private static ILayerFactory instance;

    protected DefaultLayerFactory() {
    }

    public static synchronized ILayerFactory getInstance() {
        if (instance == null) {
            instance = new DefaultLayerFactory();
        }
        return instance;
    }

    @Override
    public <T extends AbstractSystemLayer> T createSystemLayer(LayerContainer lc2, Class<T> layerType) {
        if (lc2 == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        if (layerType == null) {
            throw new IllegalArgumentException("layer type can not be NULL");
        }
        LOGGER.fine("creating system layer of type = " + layerType.getName());
        try {
            Constructor<T> con = layerType.getConstructor(LayerContainer.class);
            return (T)((AbstractSystemLayer)con.newInstance(lc2));
        }
        catch (Exception ex) {
            LOGGER.throwing(this.getClass().getName(), "createSystemLayer", ex);
            throw new IllegalStateException("factory was unable to create a system layer of type " + layerType.getName(), ex);
        }
    }

    @Override
    public TimelineObjectLayer createTimelineLayer(LayerContainer lc2, ILayer layer) {
        return new TimelineObjectLayer(lc2, layer);
    }

    @Override
    public AbstractCustomLayer createCustomLayer(LayerContainer lc2, ILayer layer) {
        return new MissingCustomLayer(lc2, layer);
    }

    class MissingCustomLayer
    extends AbstractCustomLayer {
        public MissingCustomLayer(LayerContainer lc2, ILayer layer) {
            super(lc2, layer);
        }

        @Override
        protected void paintLayer(Graphics g2) {
            super.paintLayer(g2);
            g2.setColor(this.getLayerContainer().getForeground());
            g2.setFont(g2.getFont().deriveFont(32));
            g2.drawString(Messages.getString("DefaultLayerFactory.MISSING_CUSTOM_LAYER_IMPLEMENTATION"), 100, 100);
        }
    }
}

