/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.treetable;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.swing.action.treetable.AbstractTreeTableAction;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class CollapseNodeAction
extends AbstractTreeTableAction {
    public CollapseNodeAction(TreeTable table) {
        super(table, Messages.getString("CollapseNodeAction.NAME"), IconRegistry.getIcon(IconId.COLLAPSE_ALL));
        this.setToolTipText(Messages.getString("CollapseNodeAction.TOOLTIP"));
    }

    @Override
    public boolean isEnabled() {
        boolean containsFolders = false;
        TreePath[] selection = this.treeTable.getSelectionPaths();
        if (selection != null) {
            ITreeTableModel model = this.treeTable.getModel();
            for (TreePath path : selection) {
                Object node = path.getLastPathComponent();
                if (model.isLeaf(node)) continue;
                containsFolders = true;
                break;
            }
        }
        return this.treeTable.getSelectionCount() > 0 && containsFolders;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        TreePath[] selection = this.treeTable.getSelectionPaths();
        if (selection != null) {
            for (TreePath path : selection) {
                this.treeTable.collapsePathAnimated(path);
            }
        }
    }
}

