/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.gantt;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.action.AbstractFlexGanttAction;
import com.dlsc.flexgantt.swing.treetable.CellFocusManager;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class AbstractGanttChartAction<T extends AbstractGanttChart>
extends AbstractFlexGanttAction {
    private static final Logger LOGGER = Logger.getLogger(AbstractGanttChartAction.class.getName());
    protected T ganttChart;

    protected AbstractGanttChartAction(T gc2, String name, Icon icon) {
        super(name, icon);
        this.setGanttChart(gc2);
    }

    protected AbstractGanttChartAction(T gc2, String name) {
        super(name);
        this.setGanttChart(gc2);
    }

    public void setGanttChart(T gc2) {
        LOGGER.fine("setting new Gantt chart = " + gc2 + " on action");
        if (gc2 == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        this.ganttChart = gc2;
    }

    public T getGanttChart() {
        return this.ganttChart;
    }

    protected TreeTable findFocusedTable() {
        return this.findFocusedTable(((AbstractGanttChart)this.ganttChart).getTreeTables());
    }

    private TreeTable findFocusedTable(TreeTable[] tables) {
        for (TreeTable table : tables) {
            CellFocusManager mgr = table.getCellFocusManager();
            if (!mgr.hasFocus()) continue;
            return table;
        }
        return null;
    }
}

