/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IGridComponentListener;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.util.RollOverLabel;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class GridControl
extends RollOverLabel
implements IGridComponentListener,
MouseListener {
    private IGridComponent gridComponent;
    private Selector gridSelector;
    private AbstractGanttChart ganttChart;

    public GridControl(AbstractGanttChart gc2, IGridComponent comp) {
        if (gc2 == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        if (comp == null) {
            throw new IllegalArgumentException("grid component can not be NULL");
        }
        this.ganttChart = gc2;
        this.gridComponent = comp;
        this.gridComponent.addGridComponentListener(this);
        this.setToolTipText(Messages.getString("GridControl.TOOLTIP"));
        this.updateControl();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 1) {
                    GridControl.this.openGridSelector();
                }
            }
        });
    }

    public void tearDown() {
        this.gridComponent.removeGridComponentListener(this);
    }

    private void updateControl() {
        IGranularity grid = this.gridComponent.getGridGranularity();
        if (grid != null) {
            this.setText(this.gridComponent.getGridGranularity().getName());
        } else if (this.gridComponent.isGridAutomatic()) {
            this.setText(Messages.getString("GridControl.AUTO"));
        } else {
            this.setText(Messages.getString("GridControl.NO_GRID"));
        }
    }

    @Override
    public void gridComponentChanged() {
        this.updateControl();
    }

    public void openGridSelector() {
        ISelectorFactory sf = this.ganttChart.getSelectorFactory();
        if (this.gridSelector == null) {
            this.gridSelector = sf.createSelector(this.gridComponent, (JComponent)this, ISelectorFactory.SelectorID.GRID);
        }
        this.gridSelector.setVisible(!this.gridSelector.isVisible());
    }
}

