/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class GanttChartControl
extends JPanel
implements PropertyChangeListener {
    private AbstractGanttChart ganttChart;
    private boolean printing;

    public GanttChartControl(AbstractGanttChart ganttChart) {
        super(true);
        Color controlsBgColor;
        if (ganttChart == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        this.setOpaque(true);
        this.ganttChart = ganttChart;
        Color controlsFgColor = ganttChart.getControlsForeground();
        if (controlsFgColor != null) {
            this.setForeground(controlsFgColor);
        }
        if ((controlsBgColor = ganttChart.getControlsBackground()) != null) {
            this.setBackground(controlsBgColor);
        }
        ganttChart.addPropertyChangeListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                AbstractGanttChart gc2 = GanttChartControl.this.getGanttChart();
                gc2.requestFocusInWindow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics g2) {
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        try {
            this.printing = true;
            this.setForeground(Color.BLACK);
            this.setBackground(new Color(230, 230, 230));
            super.print(g2);
        }
        finally {
            this.printing = false;
            this.setForeground(fg);
            this.setBackground(bg);
        }
    }

    @Override
    protected void printBorder(Graphics g2) {
        if (!this.printing) {
            super.printBorder(g2);
        }
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.ganttChart)) {
            if (evt.getPropertyName().equals("controlsBgColor")) {
                this.setBackground(this.ganttChart.getControlsBackground());
            } else if (evt.getPropertyName().equals("controlsFgColor")) {
                this.setForeground(this.ganttChart.getControlsForeground());
            }
        }
    }
}

