/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.layer.DefaultDragInfoPolicy;
import com.dlsc.flexgantt.util.Messages;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeGranularityDragInfoPolicy
extends DefaultDragInfoPolicy {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

    @Override
    public Object getDragInfo(TimelineObjectPath path, IGanttChartModel model, IDatelineModel<?> datelineModel, Object dropNode, ITimeSpan dropSpan) {
        StringBuilder sb2 = new StringBuilder();
        TimeZone tz = datelineModel.getTimeZone();
        Calendar cal = Calendar.getInstance(tz);
        this.dateFormat.setTimeZone(tz);
        if (model.getTimeSpan(path.getTimelineObject()).isEvent()) {
            cal.setTimeInMillis(dropSpan.getStartTime());
            sb2.append(this.dateFormat.format(cal.getTime()));
        } else {
            cal.setTimeInMillis(dropSpan.getStartTime());
            sb2.append(Messages.getString("TimeGranularityDragInfoPolicy.START_TIME"));
            sb2.append(this.dateFormat.format(cal.getTime()));
            sb2.append("\n");
            cal.setTimeInMillis(dropSpan.getEndTime());
            sb2.append(Messages.getString("TimeGranularityDragInfoPolicy.END_TIME"));
            sb2.append(this.dateFormat.format(cal.getTime()));
        }
        return sb2.toString();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("date format can not be NULL");
        }
        this.dateFormat = format;
    }
}

