/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.layer.DefaultDragAndDropCommand;
import com.dlsc.flexgantt.command.layer.DefaultMultiDragAndDropCommand;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.AbstractPolicy;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultDragAndDropPolicy
extends AbstractPolicy
implements IDragAndDropPolicy {
    private static final Logger LOGGER = Logger.getLogger(DefaultDragAndDropPolicy.class.getName());

    @Override
    public int getDragActions(TimelineObjectPath path, IGanttChartModel model) {
        Object node = path.getLastPathComponent();
        Object timelineObject = path.getTimelineObject();
        this.assertClass("getDragSourceAction", "timelineObject", ITimelineObject.class, timelineObject);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("node = " + node + " key = " + model.getKey(node));
            LOGGER.fine("timelineObject = " + timelineObject);
            LOGGER.fine("model = " + model);
        }
        int actions = ((ITimelineObject)timelineObject).getDragActions();
        if (LOGGER.isLoggable(Level.FINE)) {
            switch (actions) {
                case 1: {
                    LOGGER.fine("action = ACTION_COPY");
                    break;
                }
                case 2: {
                    LOGGER.fine("action = ACTION_MOVE");
                    break;
                }
                case 3: {
                    LOGGER.fine("action = ACTION_COPY_OR_MOVE");
                    break;
                }
                case 0x40000000: {
                    LOGGER.fine("action = ACTION_LINK");
                    break;
                }
                case 0: {
                    LOGGER.fine("drop action = ACTION_NONE");
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "completely unknown action (only use values defined in DnDConstants)");
                }
            }
        }
        return actions;
    }

    @Override
    public int getDropActions(TimelineObjectPath path, IGanttChartModel model, Object newNode, IGanttChartModel newModel, long newStartTime) {
        Object node = path.getLastPathComponent();
        Object timelineObject = path.getTimelineObject();
        this.assertClass("getDropTargetAction", "node", IGanttChartNode.class, node);
        this.assertClass("getDropTargetAction", "newNode", IGanttChartNode.class, newNode);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("node = " + node + " key = " + model.getKey(node));
            LOGGER.fine("timelineObject = " + timelineObject);
            LOGGER.fine("model = " + model);
            LOGGER.fine("newNode is = " + newNode + " new key = " + model.getKey(newNode));
            LOGGER.fine("newModel = " + newModel);
            LOGGER.fine("newStartTime = " + newStartTime);
        }
        int actions = ((IGanttChartNode)newNode).getDropActions(timelineObject, newStartTime);
        switch (actions) {
            case 1: {
                LOGGER.fine("action = ACTION_COPY");
                break;
            }
            case 2: {
                LOGGER.fine("action = ACTION_MOVE");
                break;
            }
            case 3: {
                LOGGER.fine("action = ACTION_COPY_OR_MOVE");
                break;
            }
            case 0x40000000: {
                LOGGER.fine("action = ACTION_LINK");
                break;
            }
            case 0: {
                LOGGER.fine("drop action = ACTION_NONE");
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, "completely unknown action (only use values defined in DnDConstants)");
            }
        }
        return actions;
    }

    @Override
    public ICommand getDragAndDropCommand(TimelineObjectPath path, IGanttChartModel model, Object newNode, IGanttChartModel newModel, long newStartTime, Object[] timelineObjects, ILayer layer, int dropAction) {
        Object node = path.getLastPathComponent();
        Object droppedTimelineObject = path.getTimelineObject();
        this.assertClass("getDragAndDropCommand", "node", IGanttChartNode.class, node);
        this.assertClass("getDragAndDropCommand", "timelineObject", ITimelineObject.class, droppedTimelineObject);
        this.assertClass("getDragAndDropCommand", "newNode", IGanttChartNode.class, newNode);
        this.assertClass("getDragAndDropCommand", "model", DefaultGanttChartModel.class, model);
        this.assertClass("getDragAndDropCommand", "newModel", DefaultGanttChartModel.class, newModel);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("node = " + node + " key = " + model.getKey(node));
            LOGGER.fine("timelineObject = " + droppedTimelineObject);
            LOGGER.fine("model = " + model);
            LOGGER.fine("newNode = " + newNode + " key = " + model.getKey(node));
            LOGGER.fine("newModel = " + newModel);
            LOGGER.fine("newStartTime = " + newStartTime);
            LOGGER.fine("layer = " + layer);
            switch (dropAction) {
                case 1: {
                    LOGGER.fine("action = ACTION_COPY");
                    break;
                }
                case 2: {
                    LOGGER.fine("action = ACTION_MOVE");
                    break;
                }
                case 3: {
                    LOGGER.fine("action = ACTION_COPY_OR_MOVE");
                    break;
                }
                case 0x40000000: {
                    LOGGER.fine("action = ACTION_LINK");
                    break;
                }
                case 0: {
                    LOGGER.fine("drop action = ACTION_NONE");
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "completely unknown action (only use values defined in DnDConstants)");
                }
            }
            if (timelineObjects != null) {
                for (Object tlo : timelineObjects) {
                    LOGGER.fine("   selected = " + tlo);
                }
            }
        }
        if (dropAction == 0) {
            throw new IllegalArgumentException("a drop command can not be returned when the drop action is DnDConstants.ACTION_NONE");
        }
        if (timelineObjects == null || timelineObjects.length == 0) {
            return new DefaultDragAndDropCommand((IGanttChartNode)node, layer, (ITimelineObject)droppedTimelineObject, (DefaultGanttChartModel)model, (IGanttChartNode)newNode, (DefaultGanttChartModel)newModel, newStartTime, dropAction);
        }
        int s2 = timelineObjects.length + 1;
        ITimelineObject[] tlo = new ITimelineObject[s2];
        tlo[0] = (ITimelineObject)droppedTimelineObject;
        System.arraycopy(timelineObjects, 0, tlo, 1, s2 - 1);
        return new DefaultMultiDragAndDropCommand((IGanttChartNode)node, layer, tlo, (DefaultGanttChartModel)model, (IGanttChartNode)newNode, (DefaultGanttChartModel)newModel, dropAction);
    }
}

