/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.AbstractPolicy;
import com.dlsc.flexgantt.policy.layer.ICrosshairPolicy;
import com.dlsc.flexgantt.util.LabelType;
import java.text.DateFormat;
import java.util.Date;

public class DefaultCrosshairPolicy
extends AbstractPolicy
implements ICrosshairPolicy {
    private DateFormat timelineDateFormat = DateFormat.getDateTimeInstance(3, 3);
    private DateFormat timelineObjectDateFormat = DateFormat.getDateTimeInstance(3, 3);

    @Override
    public String getLabel(Object node, TimelineObjectPath path, IGanttChartModel model, long time, ICrosshairPolicy.LabelPosition position) {
        Object timelineObject = null;
        if (path != null) {
            timelineObject = path.getTimelineObject();
        }
        switch (position) {
            case UPPER_RIGHT: {
                return this.timelineDateFormat.format(new Date(time));
            }
            case UPPER_LEFT: {
                if (timelineObject == null) break;
                ITimeSpan span = model.getTimeSpan(timelineObject);
                Date start = new Date(span.getStartTime());
                if (span.isEvent()) {
                    return this.timelineObjectDateFormat.format(start);
                }
                Date end = new Date(span.getEndTime());
                return this.timelineObjectDateFormat.format(start) + " - " + this.timelineObjectDateFormat.format(end);
            }
            case LOWER_RIGHT: {
                if (node == null) break;
                this.assertClass("getCrosshairLabel", "node", IGanttChartNode.class, node);
                IGanttChartNode ganttNode = (IGanttChartNode)node;
                Object key = ganttNode.getKey();
                if (key == null) break;
                return key.toString();
            }
            case LOWER_LEFT: {
                if (timelineObject == null) break;
                this.assertClass("getCrosshairLabel", "timelineObject", ITimelineObject.class, timelineObject);
                return ((ITimelineObject)timelineObject).getLabel(LabelType.NAME);
            }
        }
        return null;
    }

    @Override
    public boolean isLabelVisible(ICrosshairPolicy.LabelPosition position) {
        return true;
    }

    public DateFormat getTimelineDateFormat() {
        return this.timelineDateFormat;
    }

    public void setTimelineDateFormat(DateFormat format) {
        this.timelineDateFormat = format;
    }

    public DateFormat getTimelineObjectDateFormat() {
        return this.timelineObjectDateFormat;
    }

    public void setTimelineObjectDateFormat(DateFormat format) {
        this.timelineObjectDateFormat = format;
    }
}

