/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.renderer.table;

import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.mpxj.Duration;

public class DurationTableCellRenderer
extends DefaultTableCellRenderer {
    private NumberFormat format = DecimalFormat.getNumberInstance();

    public DurationTableCellRenderer() {
        this.format.setMinimumFractionDigits(1);
        this.format.setMaximumFractionDigits(1);
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null && value instanceof Duration) {
            Duration duration = (Duration)value;
            this.setText(this.format.format(duration.getDuration()) + " " + duration.getUnits().toString());
        }
        return this;
    }
}

