/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.renderer;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Priority;
import net.sf.mpxj.Relation;
import net.sf.mpxj.TimeUnit;

public class MSProjectTreeTableCellRenderer
extends DefaultTreeTableCellRenderer {
    private static final Icon taskIcon = IconRegistry.getIcon(IconId.TASK);

    @Override
    public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
        Component comp = super.getTreeTableCellRendererComponent(tree, node, value, depth, selected, expanded, leaf, row, column, hasFocus);
        if (!leaf) {
            Font font = tree.getFont();
            comp.setFont(font.deriveFont(1));
        }
        return comp;
    }

    @Override
    protected Icon getIcon(Object node, Object value, int column, boolean leaf, boolean expanded) {
        if ((column == -1 || column == Integer.MIN_VALUE) && value != null) {
            if (leaf) {
                return taskIcon;
            }
            return super.getIcon(node, value, column, leaf, expanded);
        }
        return null;
    }

    @Override
    protected String getText(Object node, Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof Priority) {
                switch (((Priority)obj).getValue()) {
                    case 600: {
                        return "High";
                    }
                    case 700: {
                        return "Higher";
                    }
                    case 900: {
                        return "Highest";
                    }
                    case 400: {
                        return "Low";
                    }
                    case 300: {
                        return "Lower";
                    }
                    case 100: {
                        return "Lowest";
                    }
                    case 500: {
                        return "Medium";
                    }
                    case 800: {
                        return "Very High";
                    }
                    case 200: {
                        return "Very Low";
                    }
                }
            } else {
                if (obj instanceof Duration) {
                    Duration duration = (Duration)obj;
                    double d2 = duration.getDuration();
                    TimeUnit unit = duration.getUnits();
                    String unitString = unit.toString();
                    return d2 + " " + unitString;
                }
                if (obj instanceof List) {
                    List list = (List)obj;
                    StringBuilder sb2 = new StringBuilder();
                    for (Object o2 : list) {
                        sb2.append(this.getText(node, o2));
                        sb2.append(" ");
                    }
                    return sb2.toString();
                }
                if (obj instanceof Relation) {
                    Relation rel = (Relation)obj;
                    return rel.getTargetTask().getID().toString();
                }
                throw new IllegalArgumentException("no conversion for type " + obj.getClass().getName());
            }
        }
        return "";
    }
}

