/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.gantt;

import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskTimeSpan;
import com.dlsc.flexgantt.util.LabelType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;

public class MSProjectTaskTimelineObject
extends DefaultActivityObject<Task> {
    private static final Map<Task, MSProjectTaskTimelineObject> cache = new HashMap<Task, MSProjectTaskTimelineObject>();

    private MSProjectTaskTimelineObject(Task task) {
        super(task.getName(), new MSProjectTaskTimeSpan(task));
        this.setUserObject(task);
        this.setDragActions(0);
        this.setStartTimeChangeable(true);
        this.setDurationChangeable(true);
        this.setPercentageComplete(task.getPercentageComplete().intValue());
        List<ResourceAssignment> list = task.getResourceAssignments();
        if (list.size() > 0) {
            StringBuilder sb2 = new StringBuilder();
            Iterator<ResourceAssignment> iter = list.iterator();
            while (iter.hasNext()) {
                ResourceAssignment ra = iter.next();
                Resource res = ra.getResource();
                if (res == null) continue;
                sb2.append(res.getName());
                if (!iter.hasNext()) continue;
                sb2.append(", ");
            }
            this.setLabel(sb2.toString(), LabelType.DESCRIPTION);
        }
        List<Task> children = task.getChildTasks();
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Task child = children.get(i2);
            MSProjectTaskTimelineObject tlo = MSProjectTaskTimelineObject.getTaskActivity(child);
            this.addChild(tlo);
        }
    }

    @Override
    public Object getPopupObject(boolean extended) {
        if (!extended) {
            Task task = (Task)this.getUserObject();
            String notes = task.getNotes();
            if (notes.length() > 0) {
                return notes;
            }
        } else {
            return "No extended annotation";
        }
        return null;
    }

    public Task getTask() {
        return (Task)this.getUserObject();
    }

    public static MSProjectTaskTimelineObject getTaskActivity(Task task) {
        MSProjectTaskTimelineObject activity = cache.get(task);
        if (activity == null) {
            activity = new MSProjectTaskTimelineObject(task);
            cache.put(task, activity);
        }
        return activity;
    }

    @Override
    public boolean isParent() {
        return ((Task)this.getUserObject()).getChildTasks().size() > 0;
    }
}

