/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import java.util.Date;
import net.sf.mpxj.Task;

public class MSProjectTaskTimeSpan
extends TimeSpan {
    private Task task;

    public MSProjectTaskTimeSpan(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task can not be NULL");
        }
        this.task = task;
    }

    @Override
    public boolean isEvent() {
        return this.task.getMilestone() || super.isEvent();
    }

    @Override
    public long getStartTime() {
        Date d2 = this.task.getStart();
        if (d2 != null) {
            return d2.getTime();
        }
        return 0L;
    }

    @Override
    public long getEndTime() {
        Date d2;
        if (!this.task.getMilestone() && (d2 = this.task.getFinish()) != null) {
            return d2.getTime();
        }
        return this.getStartTime();
    }

    @Override
    public ITimeSpan union(ITimeSpan span) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("MS Project tasks can not be united");
    }

    public Task getTask() {
        return this.task;
    }
}

