/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.msproject.AbstractMSProjectContentPanel;
import com.dlsc.flexgantt.msproject.MSProjectGanttChartPanel;
import com.dlsc.flexgantt.msproject.MSProjectIntroPage;
import com.dlsc.flexgantt.msproject.MSProjectViewer;
import com.dlsc.flexgantt.msproject.ResourceSheetPanel;
import com.dlsc.flexgantt.msproject.TaskSheetPanel;
import com.dlsc.flexgantt.msproject.UnimplementedPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewContainer;
import net.sf.mpxj.mpp.AbstractView;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;

public class MSProjectWorkbench
extends JPanel {
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private Map<View, AbstractMSProjectContentPanel> panelMap;
    private MSProjectIntroPage introPage;
    private MSProjectViewer viewer;
    private View currentView;

    public MSProjectWorkbench(MSProjectViewer viewer) {
        this.setLayout(new BorderLayout());
        this.viewer = viewer;
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.panelMap = new HashMap<View, AbstractMSProjectContentPanel>();
        this.introPage = new MSProjectIntroPage(this);
        this.cardPanel.add("Intro", this.introPage);
        this.add("Center", this.cardPanel);
    }

    private JComponent createViewComponent(ProjectFile projectFile, AbstractView view) {
        System.out.println("view with name = " + view.getName() + " and ID = " + view.getID() + " is of type " + view.getType());
        Table table = view.getTable();
        if (table != null) {
            System.out.println("   table resource flag = " + table.getResourceFlag());
        } else {
            System.out.println("   no table for view");
        }
        switch (view.getType()) {
            case CALENDAR: {
                return this.createCalendarComponent(projectFile, view);
            }
            case NETWORK_DIAGRAM: {
                return this.createNetworkDiagram(projectFile, view);
            }
            case GANTT_CHART: {
                return this.createGanttChart(projectFile, view);
            }
            case RELATIONSHIP_DIAGRAM: {
                return this.createRelationshipDiagram(projectFile, view);
            }
            case RESOURCE_FORM: {
                return this.createResourceForm(projectFile, view);
            }
            case RESOURCE_GRAPH: {
                return this.createResourceGraph(projectFile, view);
            }
            case RESOURCE_NAME_FORM: {
                return this.createResourceNameForm(projectFile, view);
            }
            case RESOURCE_SHEET: {
                return this.createResourceSheet(projectFile, view);
            }
            case RESOURCE_USAGE: {
                return this.createResourceUsage(projectFile, view);
            }
            case TASK_DETAILS_FORM: {
                return this.createTaskDetailsForm(projectFile, view);
            }
            case TASK_FORM: {
                return this.createTaskForm(projectFile, view);
            }
            case TASK_NAME_FORM: {
                return this.createTaskNameForm(projectFile, view);
            }
            case TASK_SHEET: {
                return this.createTaskSheet(projectFile, view);
            }
            case TASK_USAGE: {
                return this.createTaskUsage(projectFile, view);
            }
        }
        return this.createUnknownView(view);
    }

    private JComponent createTaskUsage(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createCalendarComponent(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createNetworkDiagram(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createGanttChart(ProjectFile projectFile, AbstractView view) {
        return new MSProjectGanttChartPanel(this, projectFile, view);
    }

    private JComponent createRelationshipDiagram(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createResourceForm(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createResourceGraph(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createResourceNameForm(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createResourceSheet(ProjectFile projectFile, AbstractView view) {
        return new ResourceSheetPanel(this, projectFile, view);
    }

    private JComponent createResourceUsage(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createTaskDetailsForm(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createTaskForm(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createTaskNameForm(ProjectFile projectFile, AbstractView view) {
        return new UnimplementedPanel(this, projectFile, view);
    }

    private JComponent createTaskSheet(ProjectFile projectFile, AbstractView view) {
        return new TaskSheetPanel(this, projectFile, view);
    }

    private JComponent createUnknownView(AbstractView view) {
        return new JLabel("Unknown view type: " + view.getType());
    }

    public void load(File file) throws FileNotFoundException, InstantiationException, IllegalAccessException, MPXJException {
        this.load(file.getName(), new FileInputStream(file));
    }

    public void load(String fileName, InputStream stream) throws InstantiationException, IllegalAccessException, MPXJException {
        this.viewer.getMainFrame().setTitle(this.viewer.getContext().getResourceMap().getString("Application.title", new String[0]) + " - " + fileName);
        ProjectReader reader = ProjectReaderUtility.getProjectReader(fileName);
        this.introPage.setTaskName("Reading file...");
        ProjectFile projectFile = reader.read(stream);
        ViewContainer views = projectFile.getViews();
        TableContainer tables = projectFile.getTables();
        for (View view : views) {
            AbstractView v2 = (AbstractView)view;
            System.out.println("view: " + v2.getName() + ", table = " + v2.getTable());
        }
        this.panelMap.clear();
        this.cardPanel.removeAll();
        this.cardPanel.add("intro", this.introPage);
        JProgressBar progressBar = this.introPage.getProgressBar();
        int viewCount = views.size();
        progressBar.setMaximum(viewCount - 1);
        this.introPage.setTaskName("Building user interface...");
        AbstractView initialView = null;
        for (int i2 = 0; i2 < viewCount; ++i2) {
            AbstractView view = (AbstractView)views.get(i2);
            if (initialView == null) {
                initialView = view;
            }
            JComponent comp = this.createViewComponent(projectFile, view);
            this.cardPanel.add(view.getID().toString(), comp);
            this.panelMap.put(view, (AbstractMSProjectContentPanel)comp);
            progressBar.setValue(i2);
        }
        this.showView(initialView);
        this.firePropertyChange("projectFile", null, projectFile);
    }

    public void showView(View view) {
        System.out.println("showing view with id " + view.getID());
        View oldView = this.currentView;
        this.currentView = view;
        this.cardLayout.show(this.cardPanel, view.getID().toString());
        AbstractMSProjectContentPanel panel = this.panelMap.get(view);
        panel.activate();
        this.firePropertyChange("view", oldView, view);
    }

    public void setTable(Table table) {
        AbstractMSProjectContentPanel panel = this.getCurrentContentPanel();
        panel.setTable(table);
    }

    public AbstractMSProjectContentPanel getCurrentContentPanel() {
        AbstractMSProjectContentPanel panel = this.panelMap.get(this.currentView);
        return panel;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public void showTable(Table table) {
        AbstractMSProjectContentPanel panel = this.getCurrentContentPanel();
        panel.setTable(table);
    }
}

