/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.View;
import net.sf.mpxj.mpp.AbstractView;

public class MSProjectMenuBar
extends JMenuBar
implements PropertyChangeListener {
    private static final int HISTORY_SIZE = 5;
    private JFileChooser chooser;
    private MSProjectWorkbench workbench;
    private JMenu tablesMenu;
    private Map<Integer, JRadioButtonMenuItem> tableItemMap;
    private JMenu fileMenu;
    private List<JMenuItem> historyItems;

    public MSProjectMenuBar(MSProjectWorkbench workbench) {
        this.workbench = workbench;
        this.tableItemMap = new HashMap<Integer, JRadioButtonMenuItem>();
        this.historyItems = new ArrayList<JMenuItem>();
        this.createFileMenu();
        this.createEditMenu();
        this.createViewMenu();
        workbench.addPropertyChangeListener(this);
    }

    private void createViewMenu() {
        JMenu viewMenu = new JMenu("View");
        this.tablesMenu = new JMenu("Tables");
        viewMenu.add(this.tablesMenu);
        JMenuItem drawerItem = new JMenuItem("Show / Hide Drawer");
        drawerItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        drawerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MSProjectMenuBar.this.workbench.getCurrentContentPanel().getSplitPane().toggle();
            }
        });
        viewMenu.add(drawerItem);
        this.add(viewMenu);
    }

    public void setProjectFile(ProjectFile file) {
        this.tablesMenu.removeAll();
        ButtonGroup group = new ButtonGroup();
        Iterator iterator = file.getTables().iterator();
        while (iterator.hasNext()) {
            Table table;
            final Table fTable = table = (Table)iterator.next();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(table.getResourceFlag() ? "Resource: " + table.getName() : "Task: " + table.getName());
            group.add(item);
            System.out.println("creating menu item for table with id " + table.getID());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    MSProjectMenuBar.this.workbench.setTable(fTable);
                }
            });
            this.tablesMenu.add(item);
            this.tableItemMap.put(table.getID(), item);
        }
    }

    public void setView(View view) {
        AbstractView gcView;
        Table table;
        if (view instanceof AbstractView && (table = (gcView = (AbstractView)view).getTable()) != null) {
            System.out.println("setting table with id " + table.getID());
            JRadioButtonMenuItem item = this.tableItemMap.get(table.getID());
            System.out.println("item = " + item);
            if (item != null) {
                item.setSelected(true);
            }
        }
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.add(this.fileMenu);
        JMenuItem openItem = new JMenuItem("Open...");
        openItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fileMenu.add(openItem);
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                File file;
                if (MSProjectMenuBar.this.chooser == null) {
                    MSProjectMenuBar.this.chooser = new JFileChooser();
                    MSProjectMenuBar.this.chooser.setPreferredSize(new Dimension(600, 500));
                    MSProjectMenuBar.this.chooser.setDialogTitle("Open MSProject File");
                    MSProjectMenuBar.this.chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f2) {
                            if (f2.isFile() && (f2.getName().endsWith(".mpx") || f2.getName().endsWith(".mpp"))) {
                                return true;
                            }
                            return f2.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "Microsoft Project Files (*.mpp, *.mpx)";
                        }
                    });
                }
                MSProjectMenuBar.this.chooser.setMultiSelectionEnabled(false);
                if (MSProjectMenuBar.this.chooser.showOpenDialog(MSProjectMenuBar.this.workbench) == 0 && (file = MSProjectMenuBar.this.chooser.getSelectedFile()) != null) {
                    MSProjectMenuBar.this.loadFile(file);
                }
            }
        });
        this.fileMenu.addSeparator();
        JMenuItem clearHistory = new JMenuItem("Clear History");
        this.fileMenu.add(clearHistory);
        clearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MSProjectMenuBar.this.clearHistory();
            }
        });
        Preferences prefs = Preferences.userRoot();
        for (int i2 = 0; i2 < 5; ++i2) {
            final String file = prefs.get(this.createFileKey(i2), null);
            if (file == null) continue;
            JMenuItem item = new JMenuItem(this.createFileName(file));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    MSProjectMenuBar.this.loadFile(file);
                }
            });
            this.fileMenu.add(item);
            this.historyItems.add(item);
        }
        this.fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit...");
        this.fileMenu.add(exitItem);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
    }

    private void loadFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.workbench, "File does not exist anymore!", "Error", 0);
        }
        this.loadFile(file);
    }

    private void loadFile(File file) {
        try {
            this.workbench.load(file);
            this.addFileToHistory(file.getAbsolutePath());
        }
        catch (InstantiationException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        catch (MPXJException e2) {
            e2.printStackTrace();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    private void clearHistory() {
        Preferences prefs = Preferences.userRoot();
        for (int i2 = 0; i2 < 5; ++i2) {
            prefs.remove(this.createFileKey(i2));
        }
        for (JMenuItem item : this.historyItems) {
            this.fileMenu.remove(item);
        }
        this.historyItems.clear();
    }

    private void addFileToHistory(String fileName) {
        String file;
        int i2;
        Stack<String> stack = new Stack<String>();
        Preferences prefs = Preferences.userRoot();
        boolean duplicate = false;
        for (i2 = 0; i2 < 5; ++i2) {
            file = prefs.get(this.createFileKey(i2), null);
            if (file == null) continue;
            if (file.equals(fileName)) {
                duplicate = true;
                break;
            }
            stack.push(file);
        }
        if (!duplicate) {
            stack.push(fileName);
            for (i2 = 0; i2 < 5; ++i2) {
                if (stack.isEmpty() || (file = (String)stack.pop()) == null) continue;
                prefs.put(this.createFileKey(i2), file);
            }
        }
    }

    private String createFileKey(int index) {
        return "ms-project-viewer-file-history-" + index;
    }

    private String createFileName(String name) {
        return name;
    }

    private void createEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        this.add(editMenu);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println(evt.getPropertyName());
        if (evt.getSource().equals(this.workbench)) {
            if (evt.getPropertyName().equals("projectFile")) {
                ProjectFile file = (ProjectFile)evt.getNewValue();
                this.setProjectFile(file);
            } else if (evt.getPropertyName().equals("view")) {
                this.setView((View)evt.getNewValue());
            }
        }
    }
}

