/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import com.dlsc.flexgantt.msproject.renderer.list.ViewListCellRenderer;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewContainer;

public class MSProjectHeader
extends JPanel
implements ActionListener {
    private ProjectFile projectFile;
    private JLabel primaryHeaderLabel;
    private JLabel secondaryHeaderLabel;
    private JComboBox viewSelectionBox;
    private MSProjectWorkbench workbench;
    private View view;

    public MSProjectHeader(MSProjectWorkbench workbench, ProjectFile projectFile, View view) {
        this.workbench = workbench;
        this.view = view;
        this.projectFile = projectFile;
        this.primaryHeaderLabel = new JLabel("");
        this.secondaryHeaderLabel = new JLabel("");
        this.setLayout(new MigLayout("", "[]20[grow][]", "[]"));
        this.add((Component)this.primaryHeaderLabel, "");
        this.add((Component)this.secondaryHeaderLabel, "");
        this.viewSelectionBox = new JComboBox();
        this.viewSelectionBox.setRenderer(new ViewListCellRenderer());
        this.add(this.viewSelectionBox);
        BizLafControl.get().setStyle(this, ":bizlaf:Header");
        BizLafControl.get().setStyle(this.primaryHeaderLabel, ":bizlaf:HeaderPrimary");
        BizLafControl.get().setStyle(this.secondaryHeaderLabel, ":bizlaf:HeaderSeconary");
        if (view != null) {
            this.secondaryHeaderLabel.setText(view.getName());
            ViewContainer views = projectFile.getViews();
            Collections.sort(views, new Comparator<View>(){

                @Override
                public int compare(View v1, View v2) {
                    String n1 = v1.getName();
                    String n2 = v2.getName();
                    if (n1.startsWith("*") && !n2.startsWith("*")) {
                        return -1;
                    }
                    if (!n1.startsWith("*") && n2.startsWith("*")) {
                        return 1;
                    }
                    return v1.getName().compareTo(v2.getName());
                }
            });
            this.viewSelectionBox.setModel(new DefaultComboBoxModel<Object>(views.toArray()));
            this.viewSelectionBox.setSelectedItem(view);
            this.viewSelectionBox.addActionListener(this);
        }
        if (projectFile != null) {
            this.primaryHeaderLabel.setText(projectFile.getProjectProperties().getProjectTitle());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        View selection = (View)this.viewSelectionBox.getSelectedItem();
        this.workbench.showView(selection);
    }

    public void activate() {
        this.viewSelectionBox.setSelectedItem(this.view);
    }
}

