/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.msproject.AbstractMSProjectContentPanel;
import com.dlsc.flexgantt.msproject.MSProjectGanttChart;
import com.dlsc.flexgantt.msproject.MSProjectGanttChartToolBar;
import com.dlsc.flexgantt.msproject.MSProjectUtil;
import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectColumnModel;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskGanttChartModel;
import com.dlsc.flexgantt.swing.GanttChartStatusBar;
import com.dlsc.flexgantt.swing.layer.OverviewPalette;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.mpp.AbstractView;

public class MSProjectGanttChartPanel
extends AbstractMSProjectContentPanel {
    private MSProjectGanttChart ganttChart;

    public MSProjectGanttChartPanel(MSProjectWorkbench workbench, ProjectFile file, AbstractView view) {
        super(workbench, file, "Gantt Chart", view);
        MSProjectTaskGanttChartModel model = new MSProjectTaskGanttChartModel(file);
        this.ganttChart.setModel(model);
        this.ganttChart.updateHorizon();
        this.ganttChart.restoreViewState();
        this.ganttChart.optimizeColumnWidth();
        this.ganttChart.setVerticalSplitterLocation(this.ganttChart.getKeyColumn().getWidth());
    }

    @Override
    protected JComponent createContent() {
        this.ganttChart = new MSProjectGanttChart(this.getProjectFile(), this.getView());
        return this.ganttChart;
    }

    @Override
    protected JComponent createDrawer() {
        OverviewPalette o1 = new OverviewPalette(this.ganttChart.getPrimaryLayerContainer());
        OverviewPalette o2 = new OverviewPalette(this.ganttChart.getSecondaryLayerContainer());
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        p2.add(o1);
        p2.add(o2);
        return p2;
    }

    @Override
    protected JComponent createToolBar() {
        MSProjectGanttChartToolBar toolBar = new MSProjectGanttChartToolBar(this.ganttChart);
        toolBar.setFloatable(false);
        BizLafControl.get().setStyle(toolBar, ":bizlaf:RibbonLike");
        return toolBar;
    }

    @Override
    protected JComponent createStatusBar() {
        GanttChartStatusBar<MSProjectGanttChart> statusBar = new GanttChartStatusBar<MSProjectGanttChart>(this.ganttChart);
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        MSProjectUtil.makeLabelsShadowed(statusBar);
        return statusBar;
    }

    @Override
    public void setTable(Table table) {
        super.setTable(table);
        this.ganttChart.setColumnModel(new MSProjectColumnModel(table));
        this.ganttChart.optimizeColumnWidth();
        this.ganttChart.repaint();
    }
}

