/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.png24vista.Png24VistaIconMap;
import com.dlsc.flexgantt.msproject.MSProjectHeader;
import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import com.dlsc.flexgantt.msproject.components.AnimatedSplitPane;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.action.gantt.PreviewGanttChartAction;
import com.dlsc.flexgantt.swing.action.gantt.PrintGanttChartAction;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.mpp.AbstractView;

public abstract class AbstractMSProjectContentPanel
extends JPanel {
    private ProjectFile projectFile;
    private MSProjectWorkbench workbench;
    private MSProjectHeader header;
    private AnimatedSplitPane splitPane;
    private String title;
    private AbstractView view;

    public AbstractMSProjectContentPanel(MSProjectWorkbench workbench, ProjectFile file, String title, AbstractView view) {
        this.workbench = workbench;
        this.projectFile = file;
        this.title = title;
        this.view = view;
        this.setLayout(new MigLayout("insets 0 0 0 0, wrap 1, gap 0", "[grow]", "[][][grow][]"));
        JComponent content = this.createContent();
        JComponent drawer = this.createDrawer();
        JComponent statusBar = this.createStatusBar();
        JComponent toolBar = this.createToolBar();
        JComponent header = this.createHeader();
        this.splitPane = new AnimatedSplitPane();
        this.splitPane.setTopComponent(content);
        this.splitPane.setBottomComponent(drawer);
        statusBar.setMinimumSize(new Dimension(10, 32));
        statusBar.setPreferredSize(new Dimension(10, 32));
        this.add((Component)toolBar, "grow");
        this.add((Component)header, "grow");
        this.add((Component)this.splitPane, "grow");
        this.add((Component)statusBar, "grow");
        this.splitPane.closeWithoutAnimation();
    }

    public ProjectFile getProjectFile() {
        return this.projectFile;
    }

    public AbstractView getView() {
        return this.view;
    }

    public MSProjectWorkbench getWorkbench() {
        return this.workbench;
    }

    public void activate() {
        this.header.activate();
    }

    protected boolean isTaskView() {
        return true;
    }

    protected JComponent createHeader() {
        this.header = new MSProjectHeader(this.workbench, this.projectFile, this.view);
        return this.header;
    }

    protected JComponent createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        BizLafControl.get().setStyle(toolBar, ":bizlaf:RibbonLike");
        PrintGanttChartAction<GanttChart> print = new PrintGanttChartAction<GanttChart>(new GanttChart());
        PreviewGanttChartAction<GanttChart> preview = new PreviewGanttChartAction<GanttChart>(new GanttChart());
        Png24VistaIconMap map = new Png24VistaIconMap();
        print.putValue("SwingLargeIconKey", map.getIcon(IconId.PRINT));
        preview.putValue("SwingLargeIconKey", map.getIcon(IconId.PRINT_PREVIEW));
        print.putValue("Name", "Print");
        preview.putValue("Name", "Preview");
        toolBar.add(new JButton(print));
        toolBar.add(new JButton(preview));
        return toolBar;
    }

    protected JComponent createContent() {
        JLabel label = new JLabel("Content Missing!!!!");
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setHorizontalAlignment(0);
        return label;
    }

    protected JComponent createStatusBar() {
        StatusBar statusBar = new StatusBar();
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        return statusBar;
    }

    protected JComponent createDrawer() {
        return new JLabel("Not implemented, yet!");
    }

    protected JLabel createFooterLabel(String text) {
        JLabel footerLabel = new JLabel(text);
        this.makeFooterLabel(footerLabel);
        return footerLabel;
    }

    protected void makeFooterLabel(JLabel label) {
        BizLafControl.get().setStyle(label, ":bizlaf:Shadowed");
        label.setForeground(Color.WHITE);
    }

    public AnimatedSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void setTable(Table table) {
        System.out.println("setting new table on " + this.getClass().getName());
    }
}

