/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.scheduling;

import com.dlsc.flexgantt.model.dateline.SimpleGranularity;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.AbstractConstraint;

public class SimpleGranularityConstraint<T>
extends AbstractConstraint<T, SimpleGranularity> {
    public SimpleGranularityConstraint(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath) {
        super(sourcePath, targetPath);
        this.setBufferGranularity(SimpleGranularity.ONE);
    }

    public SimpleGranularityConstraint(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath, RelationshipType type) {
        super(sourcePath, targetPath, type);
        this.setBufferGranularity(SimpleGranularity.ONE);
    }

    @Override
    protected double getDelta(long time1, long time2, SimpleGranularity granularity) {
        long diff = time1 - time2;
        return (double)diff / (double)granularity.getMillis();
    }
}

