/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.UNDEFINED_TIME_SPAN;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeSpan
implements ITimeSpan {
    public static final TimeSpan UNDEFINED = new UNDEFINED_TIME_SPAN();
    public static final TimeSpan ALL = new TimeSpan(0L, Long.MAX_VALUE);
    private static final long MILLIS_PER_SECOND = 1000L;
    public static final ITimeSpan DEFAULT_TIME_SPAN = TimeSpan.createDefaultTimeSpan();
    private long start;
    private long end;

    public TimeSpan(long start, long end) {
        this.setSpan(start, end);
    }

    public TimeSpan(long time) {
        this.setSpan(time, time);
    }

    public TimeSpan(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        if (span.isUndefined()) {
            throw new IllegalArgumentException("the start and end time of a time span can not be initialized via an undefined span");
        }
        this.setSpan(span.getStartTime(), span.getEndTime());
    }

    public TimeSpan(Date start, Date end) {
        if (start == null) {
            throw new IllegalArgumentException("start time can not be NULL");
        }
        if (end == null) {
            throw new IllegalArgumentException("end time can not be NULL");
        }
        this.setSpan(start.getTime(), end.getTime());
    }

    public TimeSpan(Date date) {
        this(date, date);
    }

    public TimeSpan(Calendar start, Calendar end) {
        if (start == null) {
            throw new IllegalArgumentException("start time can not be NULL");
        }
        if (end == null) {
            throw new IllegalArgumentException("end time can not be NULL");
        }
        this.setSpan(start.getTimeInMillis(), end.getTimeInMillis());
    }

    public TimeSpan(Calendar time) {
        this(time, time);
    }

    public TimeSpan(int year, int month, int date, TimeZone timeZone) {
        this(year, month, date, year, month, date, timeZone);
    }

    public TimeSpan(int year, int month, int date) {
        this(year, month, date, year, month, date, TimeZone.getDefault());
    }

    public TimeSpan(int startYear, int startMonth, int startDate, int endYear, int endMonth, int endDate, TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone can not be NULL");
        }
        Calendar s2 = Calendar.getInstance(timeZone);
        s2.set(startYear, startMonth, startDate, 0, 0, 0);
        s2.set(14, 0);
        Calendar e2 = Calendar.getInstance(timeZone);
        e2.set(endYear, endMonth, endDate, 0, 0, 0);
        e2.set(14, 0);
        this.setSpan(s2.getTimeInMillis(), e2.getTimeInMillis());
    }

    public TimeSpan(int startYear, int startMonth, int startDate, int endYear, int endMonth, int endDate) {
        this(startYear, startMonth, startDate, endYear, endMonth, endDate, TimeZone.getDefault());
    }

    public TimeSpan() {
        this.setSpan(0L, 0L);
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    public Date getStartDate() {
        return new Date(this.getStartTime());
    }

    public Calendar getStartCalendar() {
        return this.getStartCalendar(TimeZone.getDefault());
    }

    public Calendar getStartCalendar(TimeZone timeZone) {
        Calendar c2 = Calendar.getInstance(timeZone);
        c2.setTimeInMillis(this.getStartTime());
        return c2;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    public Date getEndDate() {
        return new Date(this.getEndTime());
    }

    public Calendar getEndCalendar() {
        return this.getEndCalendar(TimeZone.getDefault());
    }

    public Calendar getEndCalendar(TimeZone timeZone) {
        Calendar c2 = Calendar.getInstance(timeZone);
        c2.setTimeInMillis(this.getEndTime());
        return c2;
    }

    private void setSpan(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException("start and end time can not be negative numbers (start = " + start + ", end = " + end + ")");
        }
        if (end < start) {
            throw new IllegalArgumentException("end time must be larger or equal to start time (start = " + start + ", end = " + end + ")");
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public int compareTo(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        if (this.startsBefore(span)) {
            return -1;
        }
        if (this.startsAfter(span)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean contains(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        long s1 = this.getStartTime();
        long e1 = this.getEndTime();
        long s2 = span.getStartTime();
        long e2 = span.getEndTime();
        return s1 <= s2 && e1 >= e2;
    }

    @Override
    public boolean contains(long time) {
        return this.getStartTime() <= time && time <= this.getEndTime();
    }

    @Override
    public boolean endsAfter(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        return this.getEndTime() > span.getEndTime();
    }

    @Override
    public boolean endsBefore(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        return this.getEndTime() < span.getEndTime();
    }

    @Override
    public boolean equalDuration(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        return this.getDuration() == span.getDuration();
    }

    @Override
    public long getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    @Override
    public boolean intersects(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("intersecting span can not be NULL");
        }
        long s1 = this.getStartTime();
        long e1 = this.getEndTime();
        long s2 = span.getStartTime();
        long e2 = span.getEndTime();
        if (s1 == s2 && e1 == e2) {
            return true;
        }
        return s1 <= s2 && e1 > s2 || s2 <= s1 && e2 > s1;
    }

    @Override
    public ITimeSpan intersection(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        if (this.isUndefined()) {
            if (span.isUndefined()) {
                return UNDEFINED;
            }
            return new TimeSpan(span);
        }
        if (span.isUndefined()) {
            return new TimeSpan(this);
        }
        if (this.intersects(span)) {
            long s2 = Math.max(this.getStartTime(), span.getStartTime());
            long e2 = Math.min(this.getEndTime(), span.getEndTime());
            return new TimeSpan(s2, e2);
        }
        return UNDEFINED;
    }

    @Override
    public boolean isActivity() {
        return this.getEndTime() > this.getStartTime();
    }

    @Override
    public boolean isEvent() {
        return this.getEndTime() == this.getStartTime();
    }

    @Override
    public TimeSpan move(long delta) {
        if (this.getStartTime() + delta >= 0L) {
            return new TimeSpan(this.getStartTime() + delta, this.getEndTime() + delta);
        }
        return new TimeSpan(this.getStartTime() + delta, this.getEndTime() + delta);
    }

    @Override
    public boolean startsAfter(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        return this.getStartTime() > span.getStartTime();
    }

    @Override
    public boolean startsBefore(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        return this.getStartTime() < span.getStartTime();
    }

    @Override
    public ITimeSpan union(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        if (this.isUndefined()) {
            if (span.isUndefined()) {
                return UNDEFINED;
            }
            return new TimeSpan(span);
        }
        if (span.isUndefined()) {
            return new TimeSpan(this);
        }
        long s2 = Math.min(this.start, span.getStartTime());
        long e2 = Math.max(this.end, span.getEndTime());
        return new TimeSpan(s2, e2);
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    @Override
    public boolean equals(ITimeSpan span) {
        if (span == null) {
            return false;
        }
        return this.getStartTime() == span.getStartTime() && this.getEndTime() == span.getEndTime();
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof ITimeSpan)) {
            return false;
        }
        ITimeSpan span = (ITimeSpan)o2;
        return this.equals(span);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("TimeSpan: from ");
        sb2.append(new Date(this.getStartTime()));
        sb2.append(" until ");
        sb2.append(new Date(this.getEndTime()));
        sb2.append(" [");
        sb2.append(this.getStartTime());
        sb2.append(",");
        sb2.append(this.getEndTime());
        sb2.append("]");
        return sb2.toString();
    }

    @Override
    public String toString(DateFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("date formatter can not be NULL");
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[");
        sb2.append(format.format(this.getStartDate()));
        sb2.append(" (");
        sb2.append(this.getStartTime() % 1000L);
        sb2.append(")");
        sb2.append(" - ");
        sb2.append(format.format(this.getEndDate()));
        sb2.append(" (");
        sb2.append(this.getStartTime() % 1000L);
        sb2.append(")");
        sb2.append("]");
        return sb2.toString();
    }

    private static ITimeSpan createDefaultTimeSpan() {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c2.add(1, 1);
        TimeGranularity.DAY_SHORT.adjustCalendar(c1);
        TimeGranularity.DAY_SHORT.adjustCalendar(c2);
        return new TimeSpan(c1, c2);
    }
}

