/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.util.Messages;
import java.util.Iterator;

public abstract class AbstractDragAndDropCommand
extends AbstractCommand {
    private IGanttChartNode oldOwner;
    private IGanttChartNode newOwner;
    private DefaultGanttChartModel oldModel;
    private DefaultGanttChartModel newModel;
    private ILayer layer;
    private int dropAction;

    protected AbstractDragAndDropCommand(IGanttChartNode owner, ILayer layer, DefaultGanttChartModel model, IGanttChartNode newOwner, DefaultGanttChartModel newModel, int dropAction) {
        super(Messages.getString("AbstractDragAndDropCommand.NAME"));
        if (owner == null) {
            throw new IllegalArgumentException("owner node can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (newOwner == null) {
            throw new IllegalArgumentException("new owner node can not be NULL");
        }
        if (newModel == null) {
            throw new IllegalArgumentException("new model can not be NULL");
        }
        this.oldOwner = owner;
        this.layer = layer;
        this.oldModel = model;
        this.newOwner = newOwner;
        this.newModel = newModel;
        this.dropAction = dropAction;
    }

    protected void fixRelationships(ITimelineObject object, IGanttChartNode oldOwner, IGanttChartNode newOwner, DefaultGanttChartModel oldModel, DefaultGanttChartModel newModel) {
        Iterator iter = oldModel.getRelationships();
        while (iter.hasNext()) {
            IRelationship rel = iter.next();
            TimelineObjectPath newPath = newModel.getTimelineObjectPath(newOwner, object, this.layer);
            if (rel.getSourcePath().getTimelineObject().equals(object)) {
                rel.setSourcePath(newPath);
                continue;
            }
            if (!rel.getTargetPath().getTimelineObject().equals(object)) continue;
            rel.setTargetPath(newPath);
        }
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public DefaultGanttChartModel getNewModel() {
        return this.newModel;
    }

    public DefaultGanttChartModel getOldModel() {
        return this.oldModel;
    }

    public IGanttChartNode getNewOwner() {
        return this.newOwner;
    }

    public IGanttChartNode getOldOwner() {
        return this.oldOwner;
    }

    public int getDropAction() {
        return this.dropAction;
    }
}

