/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.eventline;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineModel;
import com.dlsc.flexgantt.model.eventline.IEventlineObject;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.util.Messages;

public class DefaultChangeEventlineObjectTimeSpanCommand
extends AbstractCommand {
    private ITimeSpan oldTimeSpan;
    private ITimeSpan newTimeSpan;
    private IEventlineObject eventlineObject;
    private DefaultEventlineModel model;

    public DefaultChangeEventlineObjectTimeSpanCommand(IEventlineObject object, DefaultEventlineModel model, ITimeSpan span) {
        super(Messages.getString("DefaultChangeEventlineObjectTimeSpanCommand.NAME"));
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (object == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.eventlineObject = object;
        this.model = model;
        this.newTimeSpan = span;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) {
        this.oldTimeSpan = this.model.getTimeSpan(this.eventlineObject);
        this.model.setTimeSpan(this.eventlineObject, this.newTimeSpan);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) {
        this.model.setTimeSpan(this.eventlineObject, this.oldTimeSpan);
    }

    public DefaultEventlineModel getModel() {
        return this.model;
    }

    public ITimeSpan getNewTimeSpan() {
        return this.newTimeSpan;
    }

    public ITimeSpan getOldTimeSpan() {
        return this.oldTimeSpan;
    }

    public ITimelineObject getEventlineObject() {
        return this.eventlineObject;
    }
}

