/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.event.WeakEventListenerList;

public abstract class AbstractHighlighter
implements Highlighter {
    private transient ChangeEvent changeEvent;
    protected WeakEventListenerList listenerList = new WeakEventListenerList();
    private HighlightPredicate predicate;

    public AbstractHighlighter() {
        this(null);
    }

    public AbstractHighlighter(HighlightPredicate predicate) {
        this.setHighlightPredicate(predicate);
    }

    public void setHighlightPredicate(HighlightPredicate predicate) {
        if (predicate == null) {
            predicate = HighlightPredicate.ALWAYS;
        }
        if (this.areEqual(predicate, this.getHighlightPredicate())) {
            return;
        }
        this.predicate = predicate;
        this.fireStateChanged();
    }

    public HighlightPredicate getHighlightPredicate() {
        return this.predicate;
    }

    public Component highlight(Component component, ComponentAdapter adapter) {
        if (this.canHighlight(component, adapter) && this.getHighlightPredicate().isHighlighted(component, adapter)) {
            component = this.doHighlight(component, adapter);
        }
        return component;
    }

    protected boolean canHighlight(Component component, ComponentAdapter adapter) {
        return true;
    }

    protected abstract Component doHighlight(Component var1, ComponentAdapter var2);

    protected boolean areEqual(Object oneItem, Object anotherItem) {
        if (oneItem == null && anotherItem == null) {
            return true;
        }
        if (anotherItem != null) {
            return anotherItem.equals(oneItem);
        }
        return false;
    }

    public final void addChangeListener(ChangeListener l2) {
        this.listenerList.add(ChangeListener.class, l2);
    }

    public final void removeChangeListener(ChangeListener l2) {
        this.listenerList.remove(ChangeListener.class, l2);
    }

    public final ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected final void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i2 + 1]).stateChanged(this.changeEvent);
        }
    }
}

