/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.WindowState;
import org.jdesktop.application.utils.SwingHelper;

public class WindowProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof Window)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    private int getScreenCount() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
    }

    @Override
    public Object getSessionState(Component c2) {
        GraphicsConfiguration gc2;
        this.checkComponent(c2);
        int frameState = 0;
        if (c2 instanceof Frame) {
            frameState = ((Frame)c2).getExtendedState();
        }
        Rectangle gcBounds = (gc2 = c2.getGraphicsConfiguration()) == null ? null : gc2.getBounds();
        Rectangle frameBounds = c2.getBounds();
        if (c2 instanceof JFrame && 0 != (frameState & 6)) {
            frameBounds = SwingHelper.getWindowNormalBounds((JFrame)c2);
        }
        if (frameBounds.isEmpty()) {
            return null;
        }
        return new WindowState(frameBounds, gcBounds, this.getScreenCount(), frameState);
    }

    @Override
    public void setSessionState(Component c2, Object state) {
        this.checkComponent(c2);
        if (state != null && !(state instanceof WindowState)) {
            throw new IllegalArgumentException("invalid state");
        }
        Window w2 = (Window)c2;
        WindowState windowState = (WindowState)state;
        SwingHelper.putWindowNormalBounds(w2, windowState.getBounds());
        if (!w2.isLocationByPlatform() && state != null) {
            Rectangle gcBounds0 = windowState.getGraphicsConfigurationBounds();
            if (gcBounds0 != null && SwingHelper.isResizable(w2)) {
                if (SwingHelper.computeVirtualGraphicsBounds().contains(gcBounds0.getLocation())) {
                    w2.setBounds(windowState.getBounds());
                } else {
                    w2.setSize(windowState.getBounds().getSize());
                }
            }
            if (w2 instanceof Frame) {
                ((Frame)w2).setExtendedState(windowState.getFrameState());
            }
        }
    }
}

